"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToServiceDetails = void 0;
var _expandableFlyout = require("@kbn/expandable-flyout");
var _react = require("react");
var _search_strategy = require("../../../../../common/search_strategy");
var _kibana = require("../../../../common/lib/kibana");
var _telemetry = require("../../../../common/lib/telemetry");
var _service_details_left = require("../../service_details_left");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToServiceDetails = ({
  serviceName,
  scopeId,
  isRiskScoreExist
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  return (0, _react.useCallback)(path => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.RiskInputsExpandedFlyoutOpened, {
      entity: _search_strategy.EntityType.service
    });
    openLeftPanel({
      id: _service_details_left.ServiceDetailsPanelKey,
      params: {
        isRiskScoreExist,
        scopeId,
        service: {
          name: serviceName
        },
        path
      }
    });
  }, [isRiskScoreExist, openLeftPanel, scopeId, serviceName, telemetry]);
};
exports.useNavigateToServiceDetails = useNavigateToServiceDetails;