"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryDetails = exports.ATTACK_DISCOVERY_DETAILS_CONTAINER_TEST_ID = exports.ATTACK_DISCOVERY_DETAILS_ATTACK_CHAIN_TEST_ID = exports.ATTACK_DISCOVERY_DETAILS_ALERTS_TEST_ID = exports.ATTACK_DISCOVERY_DETAILS_ALERTS_BADGE_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _mini_attack_chain = require("../../../attack_discovery/pages/results/attack_discovery_panel/panel_header/summary_actions/mini_attack_chain");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/components/attack_discovery_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ATTACK_DISCOVERY_DETAILS_CONTAINER_TEST_ID = exports.ATTACK_DISCOVERY_DETAILS_CONTAINER_TEST_ID = 'ease-alert-flyout-attack-discovery-details-container';
const ATTACK_DISCOVERY_DETAILS_ALERTS_TEST_ID = exports.ATTACK_DISCOVERY_DETAILS_ALERTS_TEST_ID = 'ease-alert-flyout-attack-discovery-details-alerts';
const ATTACK_DISCOVERY_DETAILS_ALERTS_BADGE_TEST_ID = exports.ATTACK_DISCOVERY_DETAILS_ALERTS_BADGE_TEST_ID = 'ease-alert-flyout-attack-discovery-details-alerts-badge';
const ATTACK_DISCOVERY_DETAILS_ATTACK_CHAIN_TEST_ID = exports.ATTACK_DISCOVERY_DETAILS_ATTACK_CHAIN_TEST_ID = 'ease-alert-flyout-attack-discovery-details-attack-chain';
const ALERTS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.attackDiscovery.alerts', {
  defaultMessage: 'Alerts:'
});
const ATTACK_CHAIN = _i18n.i18n.translate('xpack.securitySolution.alertSummary.attackDiscovery.attackChainLabel', {
  defaultMessage: 'Attack chain:'
});
/**
 * Component rendered in the attack discovery section of EASE alert flyout.
 * It displays all the details for an attack discovery found for the investigated alert.
 */
const AttackDiscoveryDetails = exports.AttackDiscoveryDetails = /*#__PURE__*/(0, _react2.memo)(({
  attackDiscovery
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": ATTACK_DISCOVERY_DETAILS_CONTAINER_TEST_ID,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
            font-weight: ${euiTheme.font.weight.bold};
            margin-right: ${euiTheme.size.s};
          `,
    "data-test-subj": ATTACK_DISCOVERY_DETAILS_ALERTS_TEST_ID,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, ALERTS)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "danger",
    "data-test-subj": ATTACK_DISCOVERY_DETAILS_ALERTS_BADGE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, attackDiscovery.alertIds.length)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
            color: ${euiTheme.colors.lightShade};
            margin-left: ${euiTheme.size.m};
            margin-right: ${euiTheme.size.m};
          `,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, '|')), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
            font-weight: ${euiTheme.font.weight.bold};
            margin-right: ${euiTheme.size.s};
          `,
    "data-test-subj": ATTACK_DISCOVERY_DETAILS_ATTACK_CHAIN_TEST_ID,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, ATTACK_CHAIN)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_mini_attack_chain.MiniAttackChain, {
    attackDiscovery: attackDiscovery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })));
});
AttackDiscoveryDetails.displayName = 'AttackDiscoveryDetails';