"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceDestinationArrows = exports.SOURCE_PACKETS_FIELD_NAME = exports.SOURCE_BYTES_FIELD_NAME = exports.DESTINATION_PACKETS_FIELD_NAME = exports.DESTINATION_BYTES_FIELD_NAME = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _arrows = require("../arrows");
var _helpers = require("../arrows/helpers");
var _cell_actions_renderer = require("../../../../common/components/cell_actions/cell_actions_renderer");
var _formatted_bytes = require("../../../../common/components/formatted_bytes");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/source_destination/source_destination_arrows.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SOURCE_BYTES_FIELD_NAME = exports.SOURCE_BYTES_FIELD_NAME = 'source.bytes';
const SOURCE_PACKETS_FIELD_NAME = exports.SOURCE_PACKETS_FIELD_NAME = 'source.packets';
const DESTINATION_BYTES_FIELD_NAME = exports.DESTINATION_BYTES_FIELD_NAME = 'destination.bytes';
const DESTINATION_PACKETS_FIELD_NAME = exports.DESTINATION_PACKETS_FIELD_NAME = 'destination.packets';
const Percent = _styled.default.span`
  margin-right: 5px;
`;
Percent.displayName = 'Percent';
const SourceDestinationArrowsContainer = (0, _styled.default)(_eui.EuiFlexGroup)`
  margin: 0 2px;

  .euiToolTipAnchor {
    white-space: nowrap;
  }
`;
SourceDestinationArrowsContainer.displayName = 'SourceDestinationArrowsContainer';
const Data = (0, _styled.default)(_eui.EuiText)`
  margin: 0 5px;
`;
Data.displayName = 'Data';

/**
 * Visualizes the communication from a source as an arrow with draggable badges
 */
const SourceArrow = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  sourceBytes,
  sourceBytesPercent,
  sourcePackets,
  scopeId
}) => {
  const sourceArrowHeight = sourceBytesPercent != null ? (0, _helpers.getArrowHeightFromPercent)(sourceBytesPercent) : _helpers.DEFAULT_ARROW_HEIGHT;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: sourceArrowHeight !== null && sourceArrowHeight !== void 0 ? sourceArrowHeight : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })), sourceBytes != null && !isNaN(Number(sourceBytes)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    scopeId: scopeId,
    field: SOURCE_BYTES_FIELD_NAME,
    value: sourceBytes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, sourceBytesPercent != null ? /*#__PURE__*/_react.default.createElement(Percent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 17
    }
  }, `(${(0, _numeral.default)(sourceBytesPercent).format('0.00')}%)`) : null, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
    value: sourceBytes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 17
    }
  }))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: sourceArrowHeight !== null && sourceArrowHeight !== void 0 ? sourceArrowHeight : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  })), sourcePackets != null && !isNaN(Number(sourcePackets)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    scopeId: scopeId,
    field: SOURCE_PACKETS_FIELD_NAME,
    value: sourcePackets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }, `${sourcePackets} ${i18n.PACKETS}`)))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: sourceArrowHeight !== null && sourceArrowHeight !== void 0 ? sourceArrowHeight : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowHead, {
    direction: "arrowRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  })));
});
SourceArrow.displayName = 'SourceArrow';

/**
 * Visualizes the communication from a destination as an arrow with draggable
 * badges
 */
const DestinationArrow = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationBytes,
  destinationBytesPercent,
  destinationPackets,
  eventId,
  scopeId
}) => {
  const destinationArrowHeight = destinationBytesPercent != null ? (0, _helpers.getArrowHeightFromPercent)(destinationBytesPercent) : _helpers.DEFAULT_ARROW_HEIGHT;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowHead, {
    direction: "arrowLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: destinationArrowHeight !== null && destinationArrowHeight !== void 0 ? destinationArrowHeight : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })), destinationBytes != null && !isNaN(Number(destinationBytes)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    scopeId: scopeId,
    field: DESTINATION_BYTES_FIELD_NAME,
    value: destinationBytes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, destinationBytesPercent != null ? /*#__PURE__*/_react.default.createElement(Percent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 19
    }
  }, `(${(0, _numeral.default)(destinationBytesPercent).format('0.00')}%)`) : null, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
    value: destinationBytes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 19
    }
  }))))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: destinationArrowHeight !== null && destinationArrowHeight !== void 0 ? destinationArrowHeight : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  })), destinationPackets != null && !isNaN(Number(destinationPackets)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    scopeId: scopeId,
    field: DESTINATION_PACKETS_FIELD_NAME,
    value: destinationPackets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Data, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }, `${(0, _numeral.default)(destinationPackets).format('0,0')} ${i18n.PACKETS}`)))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_arrows.ArrowBody, {
    height: destinationArrowHeight !== null && destinationArrowHeight !== void 0 ? destinationArrowHeight : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  })));
});
DestinationArrow.displayName = 'DestinationArrow';

/**
 * Visualizes the communication between a source and a destination using arrows
 * that grow in thickness based on the percentage of bytes transferred, and stats badges
 */
const SourceDestinationArrows = exports.SourceDestinationArrows = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationBytes,
  destinationPackets,
  eventId,
  sourceBytes,
  sourcePackets,
  scopeId = ''
}) => {
  const maybeSourceBytes = sourceBytes != null && (0, _helpers.hasOneValue)(sourceBytes) ? sourceBytes[0] : undefined;
  const maybeSourcePackets = sourcePackets != null && (0, _helpers.hasOneValue)(sourcePackets) ? sourcePackets[0] : undefined;
  const maybeDestinationBytes = destinationBytes != null && (0, _helpers.hasOneValue)(destinationBytes) ? destinationBytes[0] : undefined;
  const maybeDestinationPackets = destinationPackets != null && (0, _helpers.hasOneValue)(destinationPackets) ? destinationPackets[0] : undefined;
  const maybeSourceBytesPercent = maybeSourceBytes != null && maybeDestinationBytes != null ? (0, _helpers.getPercent)({
    numerator: Number(maybeSourceBytes),
    denominator: Number(maybeSourceBytes) + Number(maybeDestinationBytes)
  }) : undefined;
  const maybeDestinationBytesPercent = maybeSourceBytesPercent != null ? 100 - maybeSourceBytesPercent : undefined;
  return /*#__PURE__*/_react.default.createElement(SourceDestinationArrowsContainer, {
    alignItems: "center",
    justifyContent: "center",
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 7
    }
  }, maybeSourceBytes != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(SourceArrow, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    sourceBytes: maybeSourceBytes,
    sourcePackets: maybeSourcePackets,
    sourceBytesPercent: maybeSourceBytesPercent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 13
    }
  })) : null, maybeDestinationBytes != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(DestinationArrow, {
    scopeId: scopeId,
    contextId: contextId,
    destinationBytes: maybeDestinationBytes,
    destinationPackets: maybeDestinationPackets,
    destinationBytesPercent: maybeDestinationBytesPercent,
    eventId: eventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 13
    }
  })) : null);
});
SourceDestinationArrows.displayName = 'SourceDestinationArrows';