"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.whoisRenderer = exports.reputationRenderer = exports.locationRenderer = exports.hostNameRenderer = exports.hostIdRenderer = exports.autonomousSystemRenderer = exports.IpOverviewId = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _default_renderer = require("../../../../timelines/components/field_renderers/default_renderer");
var _cell_actions_renderer = require("../../../../common/components/cell_actions/cell_actions_renderer");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("../details/translations"));
var _flyout_link = require("../../../../flyout/shared/components/flyout_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/field_renderers/field_renderers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IpOverviewId = exports.IpOverviewId = 'ip-overview';
const locationRenderer = (fieldNames, data, scopeId) => fieldNames.length > 0 && fieldNames.every(fieldName => (0, _fp.getOr)(null, fieldName, data)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 5
  }
}, fieldNames.map((fieldName, index) => {
  const locationValue = (0, _fp.getOr)('', fieldName, data);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `${IpOverviewId}-${fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }, index ? ',\u00A0' : '', /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
    scopeId: scopeId,
    field: fieldName,
    value: locationValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 15
    }
  })));
})) : (0, _empty_value.getEmptyTagValue)();
exports.locationRenderer = locationRenderer;
const autonomousSystemRenderer = (as, flowTarget, scopeId) => as && as.organization && as.organization.name && as.number ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
  scopeId: scopeId,
  field: `${flowTarget}.as.organization.name`,
  value: as.organization.name,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 7
  }
}, '/'), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
  scopeId: scopeId,
  field: `${flowTarget}.as.number`,
  value: `${as.number}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 9
  }
}))) : (0, _empty_value.getEmptyTagValue)();
exports.autonomousSystemRenderer = autonomousSystemRenderer;
const hostIdRenderer = ({
  contextID,
  host,
  ipFilter,
  noLink,
  scopeId,
  isFlyoutOpen
}) => {
  const hostName = host.name && host.name[0];
  return host.id && host.ip && (ipFilter == null || host.ip.includes(ipFilter)) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hostName != null ? /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
    rowItems: host.id,
    attrName: 'host.id',
    idPrefix: contextID ? `host-overview-${contextID}` : 'host-overview',
    scopeId: scopeId,
    render: id => noLink ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, id) : /*#__PURE__*/_react.default.createElement(_flyout_link.FlyoutLink, {
      field: 'host.name',
      value: hostName,
      scopeId: scopeId,
      isFlyoutOpen: isFlyoutOpen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 15
      }
    }, id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, host.id)) : (0, _empty_value.getEmptyTagValue)();
};
exports.hostIdRenderer = hostIdRenderer;
const hostNameRenderer = ({
  scopeId,
  host,
  ipFilter,
  isFlyoutOpen
}) => host.name && host.name[0] && host.ip && (!(ipFilter != null) || host.ip.includes(ipFilter)) ? /*#__PURE__*/_react.default.createElement(_cell_actions_renderer.CellActionsRenderer, {
  field: 'host.name',
  value: host.name[0],
  scopeId: scopeId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 141,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_flyout_link.FlyoutLink, {
  field: 'host.name',
  value: host.name[0],
  scopeId: scopeId,
  isFlyoutOpen: isFlyoutOpen,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 142,
    columnNumber: 7
  }
})) : (0, _empty_value.getEmptyTagValue)();
exports.hostNameRenderer = hostNameRenderer;
const whoisRenderer = ip => /*#__PURE__*/_react.default.createElement(_links.WhoIsLink, {
  domain: ip,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 153,
    columnNumber: 46
  }
}, i18n.VIEW_WHOIS);
exports.whoisRenderer = whoisRenderer;
const reputationRenderer = ip => /*#__PURE__*/_react.default.createElement(_links.ReputationLink, {
  domain: ip,
  direction: "column",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 156,
    columnNumber: 3
  }
});
exports.reputationRenderer = reputationRenderer;