"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskEngineSettingsState = void 0;
var _react = require("react");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformFiltersForBackend = uiFilters => {
  return uiFilters.map(f => {
    var _f$entityTypes;
    return {
      entity_types: (_f$entityTypes = f.entityTypes) !== null && _f$entityTypes !== void 0 ? _f$entityTypes : _common.DEFAULT_ENTITY_TYPES,
      filter: f.text
    };
  });
};
const settingsAreEqual = (first, second) => {
  var _first$range, _second$range, _first$range2, _second$range2;
  const normalizeFilters = filters => {
    if (!filters || filters.length === 0) return [];
    return filters.map(f => ({
      entity_types: [...(f.entity_types || [])].sort(),
      filter: (f.filter || '').trim()
    })).sort((a, b) => {
      const filterCompare = a.filter.localeCompare(b.filter);
      if (filterCompare !== 0) return filterCompare;
      return JSON.stringify(a.entity_types).localeCompare(JSON.stringify(b.entity_types));
    });
  };
  const firstFilters = normalizeFilters(first === null || first === void 0 ? void 0 : first.filters);
  const secondFilters = normalizeFilters(second === null || second === void 0 ? void 0 : second.filters);
  const alertFiltersEqual = JSON.stringify(firstFilters) === JSON.stringify(secondFilters);
  return (first === null || first === void 0 ? void 0 : first.includeClosedAlerts) === (second === null || second === void 0 ? void 0 : second.includeClosedAlerts) && (first === null || first === void 0 ? void 0 : (_first$range = first.range) === null || _first$range === void 0 ? void 0 : _first$range.start) === (second === null || second === void 0 ? void 0 : (_second$range = second.range) === null || _second$range === void 0 ? void 0 : _second$range.start) && (first === null || first === void 0 ? void 0 : (_first$range2 = first.range) === null || _first$range2 === void 0 ? void 0 : _first$range2.end) === (second === null || second === void 0 ? void 0 : (_second$range2 = second.range) === null || _second$range2 === void 0 ? void 0 : _second$range2.end) && (first === null || first === void 0 ? void 0 : first.enableResetToZero) === (second === null || second === void 0 ? void 0 : second.enableResetToZero) && alertFiltersEqual;
};
const useRiskEngineSettingsState = (savedRiskEngineSettings, isLoadingRiskEngineSettings, isError) => {
  const [selectedRiskEngineSettings, setSelectedRiskEngineSettings] = (0, _react.useState)(undefined);

  // Track when we're waiting for a save to complete and refetch
  const waitingForSaveRefetch = (0, _react.useRef)(false);
  const preSaveFilterCount = (0, _react.useRef)(0);

  // Initialize selected settings when saved settings are loaded
  (0, _react.useEffect)(() => {
    if (savedRiskEngineSettings && !selectedRiskEngineSettings) {
      setSelectedRiskEngineSettings((0, _common.getRiskScoreConfigurationWithDefaults)(savedRiskEngineSettings));
    }
  }, [savedRiskEngineSettings, selectedRiskEngineSettings]);

  // Handle error case by setting default values
  (0, _react.useEffect)(() => {
    if (isError) {
      setSelectedRiskEngineSettings((0, _common.getRiskScoreConfigurationWithDefaults)());
    }
  }, [isError]);

  // Sync selected settings after a successful save and refetch completes
  (0, _react.useEffect)(() => {
    var _savedRiskEngineSetti;
    const currentFilterCount = (savedRiskEngineSettings === null || savedRiskEngineSettings === void 0 ? void 0 : (_savedRiskEngineSetti = savedRiskEngineSettings.filters) === null || _savedRiskEngineSetti === void 0 ? void 0 : _savedRiskEngineSetti.length) || 0;
    if (waitingForSaveRefetch.current && !isLoadingRiskEngineSettings && savedRiskEngineSettings && currentFilterCount !== preSaveFilterCount.current) {
      const savedWithDefaults = (0, _common.getRiskScoreConfigurationWithDefaults)(savedRiskEngineSettings);
      setSelectedRiskEngineSettings(savedWithDefaults);
      waitingForSaveRefetch.current = false;
      preSaveFilterCount.current = 0;
    }
  }, [savedRiskEngineSettings, isLoadingRiskEngineSettings, selectedRiskEngineSettings]);
  const resetSelectedSettings = (0, _react.useCallback)(() => {
    setSelectedRiskEngineSettings((0, _common.getRiskScoreConfigurationWithDefaults)(savedRiskEngineSettings));
  }, [savedRiskEngineSettings]);
  const setSelectedDateSetting = (0, _react.useCallback)(({
    start,
    end
  }) => {
    setSelectedRiskEngineSettings(prevState => {
      if (!prevState) return undefined;
      return {
        ...prevState,
        range: {
          start,
          end
        }
      };
    });
  }, []);
  const toggleSelectedClosedAlertsSetting = (0, _react.useCallback)(() => {
    setSelectedRiskEngineSettings(prevState => {
      if (!prevState) return undefined;
      return {
        ...prevState,
        includeClosedAlerts: !prevState.includeClosedAlerts
      };
    });
  }, []);
  const toggleScoreRetainment = (0, _react.useCallback)(() => {
    setSelectedRiskEngineSettings(prevState => {
      if (!prevState) return undefined;
      return {
        ...prevState,
        enableResetToZero: !prevState.enableResetToZero
      };
    });
  }, []);
  const setAlertFilters = (0, _react.useCallback)(filters => {
    const transformedFilters = transformFiltersForBackend(filters);
    setSelectedRiskEngineSettings(prevState => {
      if (!prevState) {
        return (0, _common.getRiskScoreConfigurationWithDefaults)({
          filters: transformedFilters
        });
      }
      return {
        ...prevState,
        filters: transformedFilters
      };
    });
  }, []);

  // Getter for UI-formatted filters - memoized to prevent unnecessary transformations
  const getUIAlertFilters = (0, _react.useCallback)(() => {
    var _selectedRiskEngineSe;
    return (selectedRiskEngineSettings === null || selectedRiskEngineSettings === void 0 ? void 0 : (_selectedRiskEngineSe = selectedRiskEngineSettings.filters) === null || _selectedRiskEngineSe === void 0 ? void 0 : _selectedRiskEngineSe.map((f, idx) => ({
      id: `filter-${idx}-${Date.now()}`,
      text: f.filter,
      entityTypes: f.entity_types
    }))) || [];
  }, [selectedRiskEngineSettings]);
  const selectedSettingsMatchSavedSettings = settingsAreEqual(selectedRiskEngineSettings, (0, _common.getRiskScoreConfigurationWithDefaults)(savedRiskEngineSettings));
  return {
    selectedRiskEngineSettings,
    selectedSettingsMatchSavedSettings,
    resetSelectedSettings,
    setSelectedDateSetting,
    toggleSelectedClosedAlertsSetting,
    toggleScoreRetainment,
    setAlertFilters,
    getUIAlertFilters,
    // Expose refs for mutation hook to use
    waitingForSaveRefetch,
    preSaveFilterCount
  };
};
exports.useRiskEngineSettingsState = useRiskEngineSettingsState;