"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityLevelChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _translations = require("../../alerts_table/translations");
var _donutchart = require("../../../../common/components/charts/donutchart");
var _chart_label = require("../../../../overview/components/detection_response/alerts_by_status/chart_label");
var _columns = require("./columns");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/severity_level_panel/severity_level_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DONUT_HEIGHT = 150;
const StyledEuiLoadingSpinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  margin: auto;
`;
const SeverityLevelChart = ({
  data,
  isLoading,
  addFilter,
  showCellActions
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const columns = (0, _columns.useGetSeverityTableColumns)(showCellActions);
  const count = (0, _react.useMemo)(() => {
    return data ? data.reduce(function (prev, cur) {
      return prev + cur.value;
    }, 0) : 0;
  }, [data]);
  const fillColor = (0, _react.useCallback)(dataName => (0, _helpers.getSeverityColor)(dataName, euiTheme), [euiTheme]);
  const onDonutPartitionClicked = (0, _react.useCallback)(level => {
    if (addFilter) {
      addFilter({
        field: _ruleDataUtils.ALERT_SEVERITY,
        value: level.toLowerCase()
      });
    }
  }, [addFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    "data-test-subj": "severity-level-chart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "severity-level-table",
    columns: columns,
    items: data,
    loading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "severity-level-donut",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(StyledEuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_donutchart.DonutChart, {
    data: data,
    fillColor: fillColor,
    height: DONUT_HEIGHT,
    label: _translations.TOTAL_COUNT_OF_ALERTS,
    title: /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 20
      }
    }),
    totalCount: count,
    onPartitionClick: onDonutPartitionClicked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })));
};
exports.SeverityLevelChart = SeverityLevelChart;
SeverityLevelChart.displayName = 'SeverityLevelChart';