"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = useDataView;
var _react = require("react");
var _kibana = require("../../../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDataView(indexPatternsOrDataViewId) {
  const {
    data: {
      dataViews: dataViewsService
    }
  } = (0, _kibana.useKibana)().services;
  const [dataView, setDataView] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (dataView !== undefined) {
      return;
    }
    setIsLoading(true);
    (async () => {
      try {
        if (indexPatternsOrDataViewId.indexPatterns) {
          const indexPatternsDataView = await dataViewsService.create({
            title: indexPatternsOrDataViewId.indexPatterns.join(','),
            id: indexPatternsOrDataViewId.indexPatterns.join(','),
            allowNoIndex: true
          });
          setDataView(indexPatternsDataView);
          return;
        }
        if (indexPatternsOrDataViewId.dataViewId) {
          const ruleDataView = await dataViewsService.get(indexPatternsOrDataViewId.dataViewId);
          setDataView(ruleDataView);
        }
      } finally {
        setIsLoading(false);
      }
    })();
  }, [dataView, dataViewsService, indexPatternsOrDataViewId.indexPatterns, indexPatternsOrDataViewId.dataViewId]);
  return {
    dataView,
    isLoading
  };
}