"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePerformRulesUpgradeMutation = exports.PERFORM_RULES_UPGRADE_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _urls = require("../../../../../../common/api/detection_engine/prebuilt_rules/urls");
var _api = require("../../api");
var _use_fetch_coverage_overview_query = require("../use_fetch_coverage_overview_query");
var _use_fetch_rule_management_filters_query = require("../use_fetch_rule_management_filters_query");
var _use_fetch_rules_snooze_settings_query = require("../use_fetch_rules_snooze_settings_query");
var _use_find_rules_query = require("../use_find_rules_query");
var _use_fetch_prebuilt_rules_status_query = require("./use_fetch_prebuilt_rules_status_query");
var _use_fetch_prebuilt_rules_upgrade_review_query = require("./use_fetch_prebuilt_rules_upgrade_review_query");
var _retry_on_rate_limited_error = require("./retry_on_rate_limited_error");
var _capped_exponential_backoff = require("./capped_exponential_backoff");
var _use_fetch_prebuilt_rule_base_version_query = require("./use_fetch_prebuilt_rule_base_version_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PERFORM_RULES_UPGRADE_KEY = exports.PERFORM_RULES_UPGRADE_KEY = ['POST', _urls.PERFORM_RULE_UPGRADE_URL];
const usePerformRulesUpgradeMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRulesSnoozeSettings = (0, _use_fetch_rules_snooze_settings_query.useInvalidateFetchRulesSnoozeSettingsQuery)();
  const invalidatePrePackagedRulesStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateFetchPrebuiltRulesUpgradeReview = (0, _use_fetch_prebuilt_rules_upgrade_review_query.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery)();
  const invalidateRuleStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchCoverageOverviewQuery = (0, _use_fetch_coverage_overview_query.useInvalidateFetchCoverageOverviewQuery)();
  const invalidateFetchPrebuiltRuleBaseVerison = (0, _use_fetch_prebuilt_rule_base_version_query.useInvalidateFetchPrebuiltRuleBaseVersionQuery)();
  return (0, _reactQuery.useMutation)(args => {
    return (0, _api.performUpgradeRules)(args);
  }, {
    ...options,
    mutationKey: PERFORM_RULES_UPGRADE_KEY,
    onSettled: (...args) => {
      invalidatePrePackagedRulesStatus();
      invalidateFindRulesQuery();
      invalidateFetchRulesSnoozeSettings();
      invalidateFetchRuleManagementFilters();
      invalidateFetchPrebuiltRulesUpgradeReview();
      invalidateRuleStatus();
      invalidateFetchCoverageOverviewQuery();
      invalidateFetchPrebuiltRuleBaseVerison();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    },
    retry: _retry_on_rate_limited_error.retryOnRateLimitedError,
    retryDelay: _capped_exponential_backoff.cappedExponentialBackoff
  });
};
exports.usePerformRulesUpgradeMutation = usePerformRulesUpgradeMutation;