"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _default_risk_score = require("./default_risk_score");
var _risk_score_override = require("./risk_score_override");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/risk_score_mapping/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RiskScoreField = ({
  dataTestSubj,
  field,
  idAria,
  indices,
  isDisabled
}) => {
  var _getFieldValidityAndE;
  const {
    value,
    isMappingChecked,
    mapping
  } = field.value;
  const {
    setValue
  } = field;
  const handleDefaultRiskScoreChange = (0, _react.useCallback)(newDefaultRiskScoreValue => {
    setValue({
      value: newDefaultRiskScoreValue,
      isMappingChecked,
      mapping
    });
  }, [setValue, isMappingChecked, mapping]);
  const handleRiskScoreMappingChange = (0, _react.useCallback)(([newField]) => {
    var _newField$name;
    setValue({
      value,
      isMappingChecked,
      mapping: [{
        field: (_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '',
        operator: 'equals',
        value: '',
        risk_score: undefined
      }]
    });
  }, [setValue, value, isMappingChecked]);
  const handleRiskScoreMappingChecked = (0, _react.useCallback)(() => {
    setValue({
      value,
      isMappingChecked: !isMappingChecked,
      mapping: [...mapping]
    });
  }, [setValue, value, isMappingChecked, mapping]);
  const errorMessage = (_getFieldValidityAndE = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field).errorMessage) !== null && _getFieldValidityAndE !== void 0 ? _getFieldValidityAndE : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_default_risk_score.DefaultRiskScore, {
    dataTestSubj: dataTestSubj,
    idAria: idAria,
    onChange: handleDefaultRiskScoreChange,
    value: value,
    errorMessage: errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_score_override.RiskScoreOverride, {
    isMappingChecked: isMappingChecked,
    onToggleMappingChecked: handleRiskScoreMappingChecked,
    onMappingChange: handleRiskScoreMappingChange,
    dataTestSubj: dataTestSubj,
    idAria: idAria,
    mapping: mapping,
    indices: indices,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })));
};
exports.RiskScoreField = RiskScoreField;