"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _help_text = require("./help_text");
var i18n = _interopRequireWildcard(require("./translations"));
var styles = _interopRequireWildcard(require("./styles"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/ml_job_select/ml_job_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MlJobSelect = ({
  field,
  shouldShowHelpText = true,
  loading,
  jobs
}) => {
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const selectedJobIds = field.value;
  const handleJobSelect = selectedJobOptions => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const newlySelectedJobIds = selectedJobOptions.map(option => option.value.id);
    field.setValue(newlySelectedJobIds);
  };
  const jobOptions = jobs.map(job => {
    var _job$customSettings, _job$customSettings2;
    return {
      value: {
        id: job.id,
        description: job.description,
        name: (_job$customSettings = job.customSettings) === null || _job$customSettings === void 0 ? void 0 : _job$customSettings.security_app_display_name
      },
      // Make sure users can search for id or name.
      // The label contains the name and id because EuiComboBox uses it for the textual search.
      label: `${(_job$customSettings2 = job.customSettings) === null || _job$customSettings2 === void 0 ? void 0 : _job$customSettings2.security_app_display_name} ${job.id}`
    };
  });

  // If rule's ML job is no longer available or has not yet become available, we still want it to appear in the dropdown.
  selectedJobIds.forEach(selectedJobId => {
    const isSelectedJobAvailable = jobOptions.some(job => job.value.id === selectedJobId);
    if (!isSelectedJobAvailable) {
      jobOptions.push({
        value: {
          id: selectedJobId,
          description: '',
          name: selectedJobId
        },
        label: selectedJobId
      });
    }
  });
  const selectedJobOptions = jobOptions.filter(option => selectedJobIds.includes(option.value.id))
  // 'label' defines what is rendered inside the selected ComboBoxPill
  .map(options => {
    var _options$value$name;
    return {
      ...options,
      label: (_options$value$name = options.value.name) !== null && _options$value$name !== void 0 ? _options$value$name : options.value.id
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    className: styles.mlJobSelectClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    helpText: shouldShowHelpText && /*#__PURE__*/_react.default.createElement(_help_text.HelpText, {
      jobs: jobs,
      selectedJobIds: selectedJobIds,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 43
      }
    }),
    isInvalid: isInvalid,
    error: errorMessage,
    "data-test-subj": "mlJobSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: loading,
    onChange: handleJobSelect,
    options: jobOptions,
    placeholder: i18n.ML_JOB_SELECT_PLACEHOLDER_TEXT,
    renderOption: renderJobOption,
    rowHeight: 50,
    selectedOptions: selectedJobOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  }))))));
};
exports.MlJobSelect = MlJobSelect;
const renderJobOption = option => {
  var _option$value;
  return /*#__PURE__*/_react.default.createElement(JobDisplay
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  , {
    id: option.value.id
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    ,
    description: option.value.description,
    name: (_option$value = option.value) === null || _option$value === void 0 ? void 0 : _option$value.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 3
    }
  });
};
const JobDisplay = ({
  description,
  name,
  id
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: styles.jobDisplayClassName,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 120,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 121,
    columnNumber: 5
  }
}, name !== null && name !== void 0 ? name : id), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: description,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued",
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 123,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 124,
    columnNumber: 9
  }
}, description))));