"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncTimerangeUrlParam = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _kibana = require("../../lib/kibana");
var _use_experimental_features = require("../use_experimental_features");
var _inputs = require("../../store/inputs");
var _global_query_string = require("../../utils/global_query_string");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyncTimerangeUrlParam = () => {
  const updateTimerangeUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.timerange);
  const getInputSelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.inputsSelector(), []);
  const inputState = (0, _reactRedux.useSelector)(getInputSelector);
  const isSocTrendsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('socTrendsEnabled');
  const {
    serverless
  } = (0, _kibana.useKibana)().services;
  // only on serverless
  const isValueReportEnabled = !!serverless;
  const {
    linkTo: globalLinkTo,
    timerange: globalTimerange
  } = inputState.global;
  const {
    linkTo: timelineLinkTo,
    timerange: timelineTimerange
  } = inputState.timeline;
  const socTrendsUrlParams = (0, _react.useMemo)(() => {
    if (isSocTrendsEnabled && inputState.socTrends) {
      const {
        linkTo: socTrendsLinkTo,
        timerange: socTrendsTimerange
      } = inputState.socTrends;
      return {
        socTrends: {
          [_use_url_state.URL_PARAM_KEY.timerange]: socTrendsTimerange,
          linkTo: socTrendsLinkTo
        }
      };
    }
    return {};
  }, [inputState.socTrends, isSocTrendsEnabled]);
  const valueReportUrlParams = (0, _react.useMemo)(() => {
    if (isValueReportEnabled && inputState.valueReport) {
      const {
        linkTo: valueReportLinkTo,
        timerange: valueReportTimerange
      } = inputState.valueReport;
      return {
        valueReport: {
          [_use_url_state.URL_PARAM_KEY.timerange]: valueReportTimerange,
          linkTo: valueReportLinkTo
        }
      };
    }
    return {};
  }, [inputState.valueReport, isValueReportEnabled]);
  (0, _react.useEffect)(() => {
    updateTimerangeUrlParam({
      global: {
        [_use_url_state.URL_PARAM_KEY.timerange]: globalTimerange,
        linkTo: globalLinkTo
      },
      timeline: {
        [_use_url_state.URL_PARAM_KEY.timerange]: timelineTimerange,
        linkTo: timelineLinkTo
      },
      ...valueReportUrlParams,
      ...socTrendsUrlParams
    });
  }, [updateTimerangeUrlParam, globalLinkTo, globalTimerange, timelineLinkTo, timelineTimerange, socTrendsUrlParams, valueReportUrlParams]);
};
exports.useSyncTimerangeUrlParam = useSyncTimerangeUrlParam;