"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomaliesFilterQuery = void 0;
var _deepmerge = _interopRequireDefault(require("deepmerge"));
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnomaliesFilterQuery = (filterQuery, anomaliesFilterQuery = {}, securityJobs = [], anomalyScore, flowTarget, ip) => {
  const securityJobIds = securityJobs.map(job => job.id).map(jobId => ({
    match_phrase: {
      job_id: jobId
    }
  }));
  const filterQueryString = (0, _helpers.createFilter)(filterQuery);
  const filterQueryObject = filterQueryString ? JSON.parse(filterQueryString) : {};
  const mergedFilterQuery = _deepmerge.default.all([filterQueryObject, anomaliesFilterQuery, {
    bool: {
      filter: [{
        bool: {
          should: securityJobIds,
          minimum_should_match: 1
        }
      }, {
        match_phrase: {
          result_type: 'record'
        }
      }, flowTarget && ip && {
        match_phrase: {
          [`${flowTarget}.ip`]: ip
        }
      }, {
        range: {
          record_score: {
            gte: anomalyScore
          }
        }
      }]
    }
  }]);
  return JSON.stringify(mergedFilterQuery);
};
exports.getAnomaliesFilterQuery = getAnomaliesFilterQuery;