"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNavCategories = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNavCategories = attacksAlertsAlignmentEnabled => {
  return [{
    type: _securitySolutionNavigation.LinkCategoryType.separator,
    linkIds: [_common.SecurityPageName.dashboards]
  }, {
    type: _securitySolutionNavigation.LinkCategoryType.separator,
    linkIds: [_common.SecurityPageName.rulesLanding, attacksAlertsAlignmentEnabled ? _common.SecurityPageName.alertDetections : _common.SecurityPageName.alerts, _common.SecurityPageName.attackDiscovery, _common.SecurityPageName.cloudSecurityPostureFindings, _common.SecurityPageName.case]
  }, {
    type: _securitySolutionNavigation.LinkCategoryType.separator,
    linkIds: [_common.SecurityPageName.siemMigrationsLanding]
  }, {
    type: _securitySolutionNavigation.LinkCategoryType.separator,
    linkIds: [_common.SecurityPageName.entityAnalyticsLanding, _common.SecurityPageName.exploreLanding, _common.SecurityPageName.timelines, _common.SecurityPageName.threatIntelligence]
  }, {
    type: _securitySolutionNavigation.LinkCategoryType.separator,
    linkIds: [_common.SecurityPageName.assetInventory]
  }, {
    type: _securitySolutionNavigation.LinkCategoryType.separator,
    linkIds: [_common.SecurityPageName.siemReadiness]
  }];
};
exports.getNavCategories = getNavCategories;