"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedCount = void 0;
exports.compactNotationParts = compactNotationParts;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/formatted_number/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Until browser support accomodates the `notation="compact"` feature of Intl.NumberFormat...
 * exported for testing
 * @param num The number to format
 * @returns [mantissa ("12" in "12k+"), Scalar of compact notation (k,M,B,T), remainder indicator ("+" in "12k+")]
 */
function compactNotationParts(num) {
  var _prefixMap$get;
  if (!Number.isFinite(num)) {
    return [num, '', ''];
  }

  // "scale" here will be a term indicating how many thousands there are in the number
  // e.g. 1001 will be 1000, 1000002 will be 1000000, etc.
  const scale = Math.pow(10, 3 * Math.min(Math.floor(Math.floor(Math.log10(num)) / 3), 4));
  const compactPrefixTranslations = {
    compactThousands: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactThousands', {
      defaultMessage: 'k'
    }),
    compactMillions: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactMillions', {
      defaultMessage: 'M'
    }),
    compactBillions: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactBillions', {
      defaultMessage: 'B'
    }),
    compactTrillions: _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactTrillions', {
      defaultMessage: 'T'
    })
  };
  const prefixMap = new Map([[1, ''], [1000, compactPrefixTranslations.compactThousands], [1000000, compactPrefixTranslations.compactMillions], [1000000000, compactPrefixTranslations.compactBillions], [1000000000000, compactPrefixTranslations.compactTrillions]]);
  const hasRemainder = _i18n.i18n.translate('xpack.securitySolution.formattedNumber.compactOverflow', {
    defaultMessage: '+'
  });
  const prefix = (_prefixMap$get = prefixMap.get(scale)) !== null && _prefixMap$get !== void 0 ? _prefixMap$get : '';
  return [Math.floor(num / scale), prefix, num / scale % 1 > Number.EPSILON ? hasRemainder : ''];
}
const FormattedCountComponent = ({
  count
}) => {
  const [mantissa, scale, hasRemainder] = (0, _react.useMemo)(() => compactNotationParts(count || 0), [count]);
  if (count == null) {
    return null;
  }
  if (count === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, 0);
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.formattedNumber.countsLabel",
    description: "",
    defaultMessage: "{mantissa}{scale}{hasRemainder}",
    values: {
      mantissa: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: mantissa,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 27
        }
      }),
      scale,
      hasRemainder
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  });
};
const FormattedCount = exports.FormattedCount = /*#__PURE__*/_react.default.memo(FormattedCountComponent);