"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AllAssets = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _asset_inventory_search_bar = require("../components/asset_inventory_search_bar");
var _asset_inventory_filters = require("../components/filters/asset_inventory_filters");
var _asset_inventory_bar_chart = require("../components/asset_inventory_bar_chart");
var _asset_inventory_table_section = require("../components/asset_inventory_table_section");
var _asset_inventory_title = require("../components/asset_inventory_title");
var _use_fetch_chart_data = require("../hooks/use_fetch_chart_data/use_fetch_chart_data");
var _use_asset_inventory_url_state = require("../hooks/use_asset_inventory_url_state/use_asset_inventory_url_state");
var _use_space_id = require("../../common/hooks/use_space_id");
var _use_data_view = require("../hooks/use_data_view");
var _data_view_context = require("../hooks/data_view_context");
var _constants = require("../constants");
var _onboarding_success_callout = require("../components/onboarding/onboarding_success_callout");
var _asset_inventory_loading = require("../components/asset_inventory_loading");
var _data_view_not_found = require("../components/errors/data_view_not_found");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/pages/all_assets.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDefaultQuery = ({
  query,
  filters,
  pageFilters
}) => ({
  query,
  filters,
  pageFilters,
  sort: [['@timestamp', 'desc']]
});
const AllAssets = () => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const dataViewQuery = (0, _use_data_view.useDataView)(spaceId ? `${_constants.ASSET_INVENTORY_DATA_VIEW_ID_PREFIX}-${spaceId}` : undefined);
  if (dataViewQuery.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_asset_inventory_loading.AssetInventoryLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 12
      }
    });
  }
  if (dataViewQuery.isError) {
    return /*#__PURE__*/_react.default.createElement(_data_view_not_found.DataViewNotFound, {
      refetchDataView: dataViewQuery.refetch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 12
      }
    });
  }
  const dataViewContextValue = {
    dataView: dataViewQuery.data,
    dataViewRefetch: dataViewQuery.refetch,
    dataViewIsLoading: dataViewQuery.isLoading,
    dataViewIsRefetching: dataViewQuery.isRefetching
  };
  return /*#__PURE__*/_react.default.createElement(_data_view_context.DataViewContext.Provider, {
    value: dataViewContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AllAssetsComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
};
exports.AllAssets = AllAssets;
const AllAssetsComponent = () => {
  const state = (0, _use_asset_inventory_url_state.useAssetInventoryURLState)({
    paginationLocalStorageKey: _constants.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY,
    columnsLocalStorageKey: _constants.LOCAL_STORAGE_COLUMNS_KEY,
    defaultQuery: getDefaultQuery
  });
  const {
    sort,
    query,
    queryError,
    urlQuery,
    setUrlQuery
  } = state;
  const {
    data: chartData,
    isFetching: isFetchingChartData,
    isLoading: isLoadingChartData
  } = (0, _use_fetch_chart_data.useFetchChartData)({
    query,
    sort,
    enabled: !queryError
  });

  // Todo: Improve to a dedicated loading state that's not dependent on chart data
  const isSearchBarLoading = isLoadingChartData || isFetchingChartData;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_asset_inventory_search_bar.AssetInventorySearchBar, {
    query: urlQuery,
    setQuery: setUrlQuery,
    isLoading: isSearchBarLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_asset_inventory_title.AssetInventoryTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_onboarding_success_callout.OnboardingSuccessCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_inventory_filters.AssetInventoryFilters, {
    query: urlQuery,
    setQuery: setUrlQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_inventory_bar_chart.AssetInventoryBarChart, {
    isLoading: isLoadingChartData,
    isFetching: isFetchingChartData,
    assetInventoryChartData: !!chartData && chartData.length > 0 ? chartData : [],
    setQuery: setUrlQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_inventory_table_section.AssetInventoryTableSection, {
    state: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  })));
};