"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THREAT_PIT_KEEP_ALIVE = exports.REFERENCE = exports.OTHER_TI_DATASET_KEY = exports.MATCHED_TYPE = exports.MATCHED_ID = exports.MATCHED_FIELD = exports.MATCHED_ATOMIC = exports.LAST_SEEN = exports.INDICATOR_REFERENCE = exports.INDICATOR_MATCH_SUBFIELDS = exports.INDICATOR_MATCHED_TYPE = exports.INDICATOR_MATCHED_FIELD = exports.FIRST_SEEN = exports.FEED_NAME_PATH = exports.FEED_NAME = exports.EVENT_ENRICHMENT_INDICATOR_FIELD_MAP = exports.EVENT_DATASET = exports.ENRICHMENT_TYPES = exports.DEFAULT_EVENT_ENRICHMENT_TO = exports.DEFAULT_EVENT_ENRICHMENT_FROM = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MATCHED_ATOMIC = exports.MATCHED_ATOMIC = 'matched.atomic';
const MATCHED_FIELD = exports.MATCHED_FIELD = 'matched.field';
const MATCHED_ID = exports.MATCHED_ID = 'matched.id';
const MATCHED_TYPE = exports.MATCHED_TYPE = 'matched.type';
const INDICATOR_MATCH_SUBFIELDS = exports.INDICATOR_MATCH_SUBFIELDS = [MATCHED_ATOMIC, MATCHED_FIELD, MATCHED_TYPE];
const INDICATOR_MATCHED_FIELD = exports.INDICATOR_MATCHED_FIELD = `${_constants.ENRICHMENT_DESTINATION_PATH}.${MATCHED_FIELD}`;
const INDICATOR_MATCHED_TYPE = exports.INDICATOR_MATCHED_TYPE = `${_constants.ENRICHMENT_DESTINATION_PATH}.${MATCHED_TYPE}`;
const EVENT_DATASET = exports.EVENT_DATASET = 'event.dataset';
const FIRST_SEEN = exports.FIRST_SEEN = 'indicator.first_seen';
const LAST_SEEN = exports.LAST_SEEN = 'indicator.last_seen';
const REFERENCE = exports.REFERENCE = 'indicator.reference';
const FEED_NAME = exports.FEED_NAME = 'feed.name';
const FEED_NAME_PATH = exports.FEED_NAME_PATH = `threat.${FEED_NAME}`;
const INDICATOR_REFERENCE = exports.INDICATOR_REFERENCE = `${_constants.ENRICHMENT_DESTINATION_PATH}.${REFERENCE}`;
let ENRICHMENT_TYPES = exports.ENRICHMENT_TYPES = /*#__PURE__*/function (ENRICHMENT_TYPES) {
  ENRICHMENT_TYPES["InvestigationTime"] = "investigation_time";
  ENRICHMENT_TYPES["IndicatorMatchRule"] = "indicator_match_rule";
  return ENRICHMENT_TYPES;
}({});
const EVENT_ENRICHMENT_INDICATOR_FIELD_MAP = exports.EVENT_ENRICHMENT_INDICATOR_FIELD_MAP = {
  'file.hash.md5': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.file.hash.md5`,
  'file.hash.sha1': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.file.hash.sha1`,
  'file.hash.sha256': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.file.hash.sha256`,
  'file.pe.imphash': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.file.pe.imphash`,
  'file.elf.telfhash': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.file.elf.telfhash`,
  'file.hash.ssdeep': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.file.hash.ssdeep`,
  'source.ip': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.ip`,
  'destination.ip': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.ip`,
  'url.full': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.url.full`,
  'registry.path': `${_constants.DEFAULT_INDICATOR_SOURCE_PATH}.registry.path`
};
const DEFAULT_EVENT_ENRICHMENT_FROM = exports.DEFAULT_EVENT_ENRICHMENT_FROM = 'now-30d';
const DEFAULT_EVENT_ENRICHMENT_TO = exports.DEFAULT_EVENT_ENRICHMENT_TO = 'now';
const OTHER_TI_DATASET_KEY = exports.OTHER_TI_DATASET_KEY = '_others_ti_';
const THREAT_PIT_KEEP_ALIVE = exports.THREAT_PIT_KEEP_ALIVE = '5m';