"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  APP_ID: true,
  APP_UI_ID: true,
  ASSISTANT_FEATURE_ID: true,
  ATTACK_DISCOVERY_FEATURE_ID: true,
  CASES_FEATURE_ID: true,
  TIMELINE_FEATURE_ID: true,
  NOTES_FEATURE_ID: true,
  SERVER_APP_ID: true,
  SECURITY_FEATURE_ID: true,
  APP_NAME: true,
  APP_ICON_SOLUTION: true,
  APP_PATH: true,
  APP_INTEGRATIONS_PATH: true,
  ADD_DATA_PATH: true,
  ADD_THREAT_INTELLIGENCE_DATA_PATH: true,
  DEFAULT_BYTES_FORMAT: true,
  DEFAULT_DATE_FORMAT: true,
  DEFAULT_DATE_FORMAT_TZ: true,
  DEFAULT_INDEX_KEY: true,
  DEFAULT_NUMBER_FORMAT: true,
  DEFAULT_DATA_VIEW_ID: true,
  DEFAULT_ALERT_DATA_VIEW_ID: true,
  DEFAULT_ATTACK_DATA_VIEW_ID: true,
  DEFAULT_TIME_FIELD: true,
  DEFAULT_TIME_RANGE: true,
  DEFAULT_REFRESH_RATE_INTERVAL: true,
  DEFAULT_APP_TIME_RANGE: true,
  DEFAULT_APP_REFRESH_INTERVAL: true,
  DEFAULT_ALERTS_INDEX: true,
  DEFAULT_SIGNALS_INDEX: true,
  DEFAULT_PREVIEW_INDEX: true,
  DEFAULT_LISTS_INDEX: true,
  DEFAULT_ITEMS_INDEX: true,
  DEFAULT_RISK_SCORE_PAGE_SIZE: true,
  DEFAULT_MAX_SIGNALS: true,
  DEFAULT_SEARCH_AFTER_PAGE_SIZE: true,
  DEFAULT_ANOMALY_SCORE: true,
  DEFAULT_MAX_TABLE_QUERY_SIZE: true,
  DEFAULT_FROM: true,
  DEFAULT_TO: true,
  DEFAULT_INTERVAL_PAUSE: true,
  DEFAULT_INTERVAL_TYPE: true,
  DEFAULT_INTERVAL_VALUE: true,
  DEFAULT_TIMEPICKER_QUICK_RANGES: true,
  SCROLLING_DISABLED_CLASS_NAME: true,
  NO_ALERT_INDEX: true,
  ENDPOINT_METADATA_INDEX: true,
  ENDPOINT_METRICS_INDEX: true,
  DEFAULT_RULE_REFRESH_INTERVAL_ON: true,
  DEFAULT_RULE_REFRESH_INTERVAL_VALUE: true,
  DEFAULT_RULE_NOTIFICATION_QUERY_SIZE: true,
  SECURITY_TAG_NAME: true,
  SECURITY_TAG_DESCRIPTION: true,
  DEFAULT_SPACE_ID: true,
  DEFAULT_RELATIVE_DATE_THRESHOLD: true,
  DEFAULT_INDICATOR_SOURCE_PATH: true,
  ENRICHMENT_DESTINATION_PATH: true,
  DEFAULT_THREAT_INDEX_KEY: true,
  DEFAULT_THREAT_INDEX_VALUE: true,
  DEFAULT_THREAT_MATCH_QUERY: true,
  EXPLORE_DATA_VIEW_PREFIX: true,
  EXPLORE_PATH: true,
  DASHBOARDS_PATH: true,
  MANAGE_PATH: true,
  TIMELINES_PATH: true,
  CASES_PATH: true,
  OVERVIEW_PATH: true,
  ONBOARDING_PATH: true,
  DATA_QUALITY_PATH: true,
  REPORTS_PATH: true,
  AI_VALUE_PATH: true,
  DETECTION_RESPONSE_PATH: true,
  DETECTIONS_PATH: true,
  ALERTS_PATH: true,
  ATTACKS_PATH: true,
  ALERT_DETECTIONS: true,
  ALERT_DETAILS_REDIRECT_PATH: true,
  ALERT_SUMMARY_PATH: true,
  RULES_PATH: true,
  RULES_LANDING_PATH: true,
  RULES_ADD_PATH: true,
  RULES_UPDATES: true,
  RULES_CREATE_PATH: true,
  EXCEPTIONS_PATH: true,
  EXCEPTION_LIST_DETAIL_PATH: true,
  HOSTS_PATH: true,
  ATTACK_DISCOVERY_PATH: true,
  ASSET_INVENTORY_PATH: true,
  SIEM_READINESS_PATH: true,
  USERS_PATH: true,
  KUBERNETES_PATH: true,
  NETWORK_PATH: true,
  MANAGEMENT_PATH: true,
  COVERAGE_OVERVIEW_PATH: true,
  THREAT_INTELLIGENCE_PATH: true,
  ENDPOINTS_PATH: true,
  POLICIES_PATH: true,
  ENDPOINT_EXCEPTIONS_PATH: true,
  TRUSTED_APPS_PATH: true,
  TRUSTED_DEVICES_PATH: true,
  EVENT_FILTERS_PATH: true,
  HOST_ISOLATION_EXCEPTIONS_PATH: true,
  BLOCKLIST_PATH: true,
  RESPONSE_ACTIONS_HISTORY_PATH: true,
  ENTITY_ANALYTICS_PATH: true,
  ENTITY_ANALYTICS_MANAGEMENT_PATH: true,
  ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH: true,
  ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH: true,
  ENTITY_ANALYTICS_LANDING_PATH: true,
  ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH: true,
  ENTITY_ANALYTICS_OVERVIEW_PATH: true,
  APP_ALERTS_PATH: true,
  APP_CASES_PATH: true,
  APP_ENDPOINTS_PATH: true,
  APP_POLICIES_PATH: true,
  APP_ENDPOINT_EXCEPTIONS_PATH: true,
  APP_MANAGE_PATH: true,
  APP_TRUSTED_APPS_PATH: true,
  APP_TRUSTED_DEVICES_PATH: true,
  APP_EVENT_FILTERS_PATH: true,
  APP_HOST_ISOLATION_EXCEPTIONS_PATH: true,
  APP_BLOCKLIST_PATH: true,
  APP_RESPONSE_ACTIONS_HISTORY_PATH: true,
  NOTES_PATH: true,
  SIEM_MIGRATIONS_PATH: true,
  SIEM_MIGRATIONS_LANDING_PATH: true,
  SIEM_MIGRATIONS_RULES_PATH: true,
  SIEM_MIGRATIONS_DASHBOARDS_PATH: true,
  CONFIGURATIONS_PATH: true,
  CONFIGURATIONS_INTEGRATIONS_PATH: true,
  EXCLUDE_ELASTIC_CLOUD_INDICES: true,
  INCLUDE_INDEX_PATTERN: true,
  DEFAULT_INDEX_PATTERN: true,
  ENABLE_NEWS_FEED_SETTING: true,
  DEFAULT_AI_CONNECTOR: true,
  EXCLUDE_COLD_AND_FROZEN_TIERS_IN_ANALYZER: true,
  ENABLE_CCS_READ_WARNING_SETTING: true,
  SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING: true,
  SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM: true,
  DEFAULT_RULES_TABLE_REFRESH_SETTING: true,
  NEWS_FEED_URL_SETTING: true,
  NEWS_FEED_URL_SETTING_DEFAULT: true,
  IP_REPUTATION_LINKS_SETTING: true,
  IP_REPUTATION_LINKS_SETTING_DEFAULT: true,
  SHOW_RELATED_INTEGRATIONS_SETTING: true,
  EXTENDED_RULE_EXECUTION_LOGGING_ENABLED_SETTING: true,
  EXTENDED_RULE_EXECUTION_LOGGING_MIN_LEVEL_SETTING: true,
  EXCLUDED_DATA_TIERS_FOR_RULE_EXECUTION: true,
  ENABLE_GRAPH_VISUALIZATION_SETTING: true,
  ENABLE_ASSET_INVENTORY_SETTING: true,
  ENABLE_CLOUD_CONNECTOR_SETTING: true,
  ENABLE_SIEM_READINESS_SETTING: true,
  ENABLE_PRIVILEGED_USER_MONITORING_SETTING: true,
  ENABLE_ESQL_RISK_SCORING: true,
  LEGACY_NOTIFICATIONS_ID: true,
  UPDATE_OR_CREATE_LEGACY_ACTIONS: true,
  SHARED_EXCEPTION_LIST_URL: true,
  DETECTION_ENGINE_URL: true,
  DETECTION_ENGINE_PRIVILEGES_URL: true,
  DETECTION_ENGINE_INDEX_URL: true,
  DETECTION_ENGINE_RULES_URL: true,
  DETECTION_ENGINE_RULES_URL_FIND: true,
  DETECTION_ENGINE_TAGS_URL: true,
  DETECTION_ENGINE_RULES_BULK_ACTION: true,
  DETECTION_ENGINE_RULES_PREVIEW: true,
  DETECTION_ENGINE_RULES_IMPORT_URL: true,
  INTERNAL_DASHBOARDS_URL: true,
  INTERNAL_TAGS_URL: true,
  INTERNAL_DETECTION_ENGINE_URL: true,
  DETECTION_ENGINE_ALERTS_INDEX_URL: true,
  DETECTION_ENGINE_ALERT_SUGGEST_USERS_URL: true,
  SECURITY_TELEMETRY_URL: true,
  TIMELINE_RESOLVE_URL: true,
  TIMELINE_URL: true,
  TIMELINES_URL: true,
  TIMELINE_FAVORITE_URL: true,
  TIMELINE_DRAFT_URL: true,
  TIMELINE_EXPORT_URL: true,
  TIMELINE_IMPORT_URL: true,
  TIMELINE_PREPACKAGED_URL: true,
  TIMELINE_COPY_URL: true,
  NOTE_URL: true,
  PINNED_EVENT_URL: true,
  NOTES_PER_PAGE_HARD_LIMIT: true,
  SIGNALS_INDEX_KEY: true,
  DETECTION_ENGINE_SIGNALS_URL: true,
  DETECTION_ENGINE_SIGNALS_STATUS_URL: true,
  DETECTION_ENGINE_QUERY_SIGNALS_URL: true,
  DETECTION_ENGINE_SIGNALS_MIGRATION_URL: true,
  DETECTION_ENGINE_SIGNALS_MIGRATION_STATUS_URL: true,
  DETECTION_ENGINE_SIGNALS_FINALIZE_MIGRATION_URL: true,
  DETECTION_ENGINE_ALERT_TAGS_URL: true,
  DETECTION_ENGINE_ALERT_ASSIGNEES_URL: true,
  ALERTS_AS_DATA_URL: true,
  ALERTS_AS_DATA_FIND_URL: true,
  SECRUTIY_INTEGRATIONS_FLEET_MANAGED_INDEX_TEMPLATES_URL: true,
  SECURITY_INTEGRATIONS_CRIBL_ROUTING_PIPELINE: true,
  UNAUTHENTICATED_USER: true,
  MINIMUM_ML_LICENSE: true,
  MINIMUM_RULE_CUSTOMIZATION_LICENSE: true,
  ML_GROUP_ID: true,
  LEGACY_ML_GROUP_ID: true,
  ML_GROUP_IDS: true,
  NOTIFICATION_THROTTLE_NO_ACTIONS: true,
  NOTIFICATION_THROTTLE_RULE: true,
  NOTIFICATION_DEFAULT_FREQUENCY: true,
  TRANSFORM_STATES: true,
  WARNING_TRANSFORM_STATES: true,
  STARTED_TRANSFORM_STATES: true,
  MAX_RULES_TO_UPDATE_IN_PARALLEL: true,
  LIMITED_CONCURRENCY_ROUTE_TAG_PREFIX: true,
  RULES_TABLE_MAX_PAGE_SIZE: true,
  NEW_FEATURES_TOUR_STORAGE_KEYS: true,
  RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_METRIC_COLUMNS_STORAGE_KEY: true,
  RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_SOURCE_EVENT_TIME_RANGE_STORAGE_KEY: true,
  MAX_NUMBER_OF_NEW_TERMS_FIELDS: true,
  BULK_ADD_TO_TIMELINE_LIMIT: true,
  DEFAULT_DETECTION_PAGE_FILTERS: true,
  ALERTS_TABLE_VIEW_SELECTION_KEY: true,
  VIEW_SELECTION: true,
  ALERTS_TABLE_REGISTRY_CONFIG_IDS: true,
  DEFAULT_ALERT_TAGS_KEY: true,
  DEFAULT_ALERT_TAGS_VALUE: true,
  MAX_COMMENT_LENGTH: true,
  MAX_NOTES_PER_DOCUMENT: true,
  CASE_ATTACHMENT_ENDPOINT_TYPE_ID: true,
  MAX_MANUAL_RULE_RUN_LOOKBACK_WINDOW_DAYS: true,
  MAX_MANUAL_RULE_RUN_BULK_SIZE: true,
  MAX_BULK_FILL_RULE_GAPS_LOOKBACK_WINDOW_DAYS: true,
  MAX_BULK_FILL_RULE_GAPS_BULK_SIZE: true,
  JEST_ENVIRONMENT: true,
  PROMOTION_RULE_TAGS: true,
  SecurityPageName: true,
  ATTACKS_ALERTS_ALIGNMENT_ENABLED: true
};
exports.ASSISTANT_FEATURE_ID = exports.ASSET_INVENTORY_PATH = exports.APP_UI_ID = exports.APP_TRUSTED_DEVICES_PATH = exports.APP_TRUSTED_APPS_PATH = exports.APP_RESPONSE_ACTIONS_HISTORY_PATH = exports.APP_POLICIES_PATH = exports.APP_PATH = exports.APP_NAME = exports.APP_MANAGE_PATH = exports.APP_INTEGRATIONS_PATH = exports.APP_ID = exports.APP_ICON_SOLUTION = exports.APP_HOST_ISOLATION_EXCEPTIONS_PATH = exports.APP_EVENT_FILTERS_PATH = exports.APP_ENDPOINT_EXCEPTIONS_PATH = exports.APP_ENDPOINTS_PATH = exports.APP_CASES_PATH = exports.APP_BLOCKLIST_PATH = exports.APP_ALERTS_PATH = exports.ALERT_SUMMARY_PATH = exports.ALERT_DETECTIONS = exports.ALERT_DETAILS_REDIRECT_PATH = exports.ALERTS_TABLE_VIEW_SELECTION_KEY = exports.ALERTS_TABLE_REGISTRY_CONFIG_IDS = exports.ALERTS_PATH = exports.ALERTS_AS_DATA_URL = exports.ALERTS_AS_DATA_FIND_URL = exports.AI_VALUE_PATH = exports.ADD_THREAT_INTELLIGENCE_DATA_PATH = exports.ADD_DATA_PATH = void 0;
Object.defineProperty(exports, "ATTACKS_ALERTS_ALIGNMENT_ENABLED", {
  enumerable: true,
  get: function () {
    return _securitySolutionNavigation.ATTACKS_ALERTS_ALIGNMENT_ENABLED;
  }
});
exports.DETECTION_ENGINE_RULES_PREVIEW = exports.DETECTION_ENGINE_RULES_IMPORT_URL = exports.DETECTION_ENGINE_RULES_BULK_ACTION = exports.DETECTION_ENGINE_QUERY_SIGNALS_URL = exports.DETECTION_ENGINE_PRIVILEGES_URL = exports.DETECTION_ENGINE_INDEX_URL = exports.DETECTION_ENGINE_ALERT_TAGS_URL = exports.DETECTION_ENGINE_ALERT_SUGGEST_USERS_URL = exports.DETECTION_ENGINE_ALERT_ASSIGNEES_URL = exports.DETECTION_ENGINE_ALERTS_INDEX_URL = exports.DETECTIONS_PATH = exports.DEFAULT_TO = exports.DEFAULT_TIME_RANGE = exports.DEFAULT_TIME_FIELD = exports.DEFAULT_TIMEPICKER_QUICK_RANGES = exports.DEFAULT_THREAT_MATCH_QUERY = exports.DEFAULT_THREAT_INDEX_VALUE = exports.DEFAULT_THREAT_INDEX_KEY = exports.DEFAULT_SPACE_ID = exports.DEFAULT_SIGNALS_INDEX = exports.DEFAULT_SEARCH_AFTER_PAGE_SIZE = exports.DEFAULT_RULE_REFRESH_INTERVAL_VALUE = exports.DEFAULT_RULE_REFRESH_INTERVAL_ON = exports.DEFAULT_RULE_NOTIFICATION_QUERY_SIZE = exports.DEFAULT_RULES_TABLE_REFRESH_SETTING = exports.DEFAULT_RISK_SCORE_PAGE_SIZE = exports.DEFAULT_RELATIVE_DATE_THRESHOLD = exports.DEFAULT_REFRESH_RATE_INTERVAL = exports.DEFAULT_PREVIEW_INDEX = exports.DEFAULT_NUMBER_FORMAT = exports.DEFAULT_MAX_TABLE_QUERY_SIZE = exports.DEFAULT_MAX_SIGNALS = exports.DEFAULT_LISTS_INDEX = exports.DEFAULT_ITEMS_INDEX = exports.DEFAULT_INTERVAL_VALUE = exports.DEFAULT_INTERVAL_TYPE = exports.DEFAULT_INTERVAL_PAUSE = exports.DEFAULT_INDICATOR_SOURCE_PATH = exports.DEFAULT_INDEX_PATTERN = exports.DEFAULT_INDEX_KEY = exports.DEFAULT_FROM = exports.DEFAULT_DETECTION_PAGE_FILTERS = exports.DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT = exports.DEFAULT_DATA_VIEW_ID = exports.DEFAULT_BYTES_FORMAT = exports.DEFAULT_ATTACK_DATA_VIEW_ID = exports.DEFAULT_APP_TIME_RANGE = exports.DEFAULT_APP_REFRESH_INTERVAL = exports.DEFAULT_ANOMALY_SCORE = exports.DEFAULT_ALERT_TAGS_VALUE = exports.DEFAULT_ALERT_TAGS_KEY = exports.DEFAULT_ALERT_DATA_VIEW_ID = exports.DEFAULT_ALERTS_INDEX = exports.DEFAULT_AI_CONNECTOR = exports.DATA_QUALITY_PATH = exports.DASHBOARDS_PATH = exports.COVERAGE_OVERVIEW_PATH = exports.CONFIGURATIONS_PATH = exports.CONFIGURATIONS_INTEGRATIONS_PATH = exports.CASE_ATTACHMENT_ENDPOINT_TYPE_ID = exports.CASES_PATH = exports.CASES_FEATURE_ID = exports.BULK_ADD_TO_TIMELINE_LIMIT = exports.BLOCKLIST_PATH = exports.ATTACK_DISCOVERY_PATH = exports.ATTACK_DISCOVERY_FEATURE_ID = exports.ATTACKS_PATH = void 0;
exports.SECURITY_TAG_NAME = exports.SECURITY_TAG_DESCRIPTION = exports.SECURITY_INTEGRATIONS_CRIBL_ROUTING_PIPELINE = exports.SECURITY_FEATURE_ID = exports.SECRUTIY_INTEGRATIONS_FLEET_MANAGED_INDEX_TEMPLATES_URL = exports.SCROLLING_DISABLED_CLASS_NAME = exports.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_SOURCE_EVENT_TIME_RANGE_STORAGE_KEY = exports.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_METRIC_COLUMNS_STORAGE_KEY = exports.RULES_UPDATES = exports.RULES_TABLE_MAX_PAGE_SIZE = exports.RULES_PATH = exports.RULES_LANDING_PATH = exports.RULES_CREATE_PATH = exports.RULES_ADD_PATH = exports.RESPONSE_ACTIONS_HISTORY_PATH = exports.REPORTS_PATH = exports.PROMOTION_RULE_TAGS = exports.POLICIES_PATH = exports.PINNED_EVENT_URL = exports.OVERVIEW_PATH = exports.ONBOARDING_PATH = exports.NO_ALERT_INDEX = exports.NOTIFICATION_THROTTLE_RULE = exports.NOTIFICATION_THROTTLE_NO_ACTIONS = exports.NOTIFICATION_DEFAULT_FREQUENCY = exports.NOTE_URL = exports.NOTES_PER_PAGE_HARD_LIMIT = exports.NOTES_PATH = exports.NOTES_FEATURE_ID = exports.NEW_FEATURES_TOUR_STORAGE_KEYS = exports.NEWS_FEED_URL_SETTING_DEFAULT = exports.NEWS_FEED_URL_SETTING = exports.NETWORK_PATH = exports.ML_GROUP_IDS = exports.ML_GROUP_ID = exports.MINIMUM_RULE_CUSTOMIZATION_LICENSE = exports.MINIMUM_ML_LICENSE = exports.MAX_RULES_TO_UPDATE_IN_PARALLEL = exports.MAX_NUMBER_OF_NEW_TERMS_FIELDS = exports.MAX_NOTES_PER_DOCUMENT = exports.MAX_MANUAL_RULE_RUN_LOOKBACK_WINDOW_DAYS = exports.MAX_MANUAL_RULE_RUN_BULK_SIZE = exports.MAX_COMMENT_LENGTH = exports.MAX_BULK_FILL_RULE_GAPS_LOOKBACK_WINDOW_DAYS = exports.MAX_BULK_FILL_RULE_GAPS_BULK_SIZE = exports.MANAGE_PATH = exports.MANAGEMENT_PATH = exports.LIMITED_CONCURRENCY_ROUTE_TAG_PREFIX = exports.LEGACY_NOTIFICATIONS_ID = exports.LEGACY_ML_GROUP_ID = exports.KUBERNETES_PATH = exports.JEST_ENVIRONMENT = exports.IP_REPUTATION_LINKS_SETTING_DEFAULT = exports.IP_REPUTATION_LINKS_SETTING = exports.INTERNAL_TAGS_URL = exports.INTERNAL_DETECTION_ENGINE_URL = exports.INTERNAL_DASHBOARDS_URL = exports.INCLUDE_INDEX_PATTERN = exports.HOST_ISOLATION_EXCEPTIONS_PATH = exports.HOSTS_PATH = exports.EXTENDED_RULE_EXECUTION_LOGGING_MIN_LEVEL_SETTING = exports.EXTENDED_RULE_EXECUTION_LOGGING_ENABLED_SETTING = exports.EXPLORE_PATH = exports.EXPLORE_DATA_VIEW_PREFIX = exports.EXCLUDE_ELASTIC_CLOUD_INDICES = exports.EXCLUDE_COLD_AND_FROZEN_TIERS_IN_ANALYZER = exports.EXCLUDED_DATA_TIERS_FOR_RULE_EXECUTION = exports.EXCEPTION_LIST_DETAIL_PATH = exports.EXCEPTIONS_PATH = exports.EVENT_FILTERS_PATH = exports.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH = exports.ENTITY_ANALYTICS_PATH = exports.ENTITY_ANALYTICS_OVERVIEW_PATH = exports.ENTITY_ANALYTICS_MANAGEMENT_PATH = exports.ENTITY_ANALYTICS_LANDING_PATH = exports.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH = exports.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH = exports.ENRICHMENT_DESTINATION_PATH = exports.ENDPOINT_METRICS_INDEX = exports.ENDPOINT_METADATA_INDEX = exports.ENDPOINT_EXCEPTIONS_PATH = exports.ENDPOINTS_PATH = exports.ENABLE_SIEM_READINESS_SETTING = exports.ENABLE_PRIVILEGED_USER_MONITORING_SETTING = exports.ENABLE_NEWS_FEED_SETTING = exports.ENABLE_GRAPH_VISUALIZATION_SETTING = exports.ENABLE_ESQL_RISK_SCORING = exports.ENABLE_CLOUD_CONNECTOR_SETTING = exports.ENABLE_CCS_READ_WARNING_SETTING = exports.ENABLE_ASSET_INVENTORY_SETTING = exports.DETECTION_RESPONSE_PATH = exports.DETECTION_ENGINE_URL = exports.DETECTION_ENGINE_TAGS_URL = exports.DETECTION_ENGINE_SIGNALS_URL = exports.DETECTION_ENGINE_SIGNALS_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_FINALIZE_MIGRATION_URL = exports.DETECTION_ENGINE_RULES_URL_FIND = exports.DETECTION_ENGINE_RULES_URL = void 0;
exports.SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM = exports.SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING = exports.STARTED_TRANSFORM_STATES = exports.SIGNALS_INDEX_KEY = exports.SIEM_READINESS_PATH = exports.SIEM_MIGRATIONS_RULES_PATH = exports.SIEM_MIGRATIONS_PATH = exports.SIEM_MIGRATIONS_LANDING_PATH = exports.SIEM_MIGRATIONS_DASHBOARDS_PATH = exports.SHOW_RELATED_INTEGRATIONS_SETTING = exports.SHARED_EXCEPTION_LIST_URL = exports.SERVER_APP_ID = exports.SECURITY_TELEMETRY_URL = void 0;
Object.defineProperty(exports, "SecurityPageName", {
  enumerable: true,
  get: function () {
    return _securitySolutionNavigation.SecurityPageName;
  }
});
exports.WARNING_TRANSFORM_STATES = exports.VIEW_SELECTION = exports.USERS_PATH = exports.UPDATE_OR_CREATE_LEGACY_ACTIONS = exports.UNAUTHENTICATED_USER = exports.TRUSTED_DEVICES_PATH = exports.TRUSTED_APPS_PATH = exports.TRANSFORM_STATES = exports.TIMELINE_URL = exports.TIMELINE_RESOLVE_URL = exports.TIMELINE_PREPACKAGED_URL = exports.TIMELINE_IMPORT_URL = exports.TIMELINE_FEATURE_ID = exports.TIMELINE_FAVORITE_URL = exports.TIMELINE_EXPORT_URL = exports.TIMELINE_DRAFT_URL = exports.TIMELINE_COPY_URL = exports.TIMELINES_URL = exports.TIMELINES_PATH = exports.THREAT_INTELLIGENCE_PATH = void 0;
var _common = require("@kbn/alerting-plugin/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("./entity_analytics/constants");
Object.keys(_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _constants[key];
    }
  });
});
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * as const
 *
 * The const assertion ensures that type widening does not occur
 * https://mariusschulz.com/blog/literal-type-widening-in-typescript
 * Please follow this convention when adding to this file
 */
const APP_ID = exports.APP_ID = 'securitySolution';
const APP_UI_ID = exports.APP_UI_ID = 'securitySolutionUI';
const ASSISTANT_FEATURE_ID = exports.ASSISTANT_FEATURE_ID = 'securitySolutionAssistant';
const ATTACK_DISCOVERY_FEATURE_ID = exports.ATTACK_DISCOVERY_FEATURE_ID = 'securitySolutionAttackDiscovery';
const CASES_FEATURE_ID = exports.CASES_FEATURE_ID = 'securitySolutionCasesV3';
const TIMELINE_FEATURE_ID = exports.TIMELINE_FEATURE_ID = 'securitySolutionTimeline';
const NOTES_FEATURE_ID = exports.NOTES_FEATURE_ID = 'securitySolutionNotes';
const SERVER_APP_ID = exports.SERVER_APP_ID = 'siem';
const SECURITY_FEATURE_ID = exports.SECURITY_FEATURE_ID = 'siemV4';
const APP_NAME = exports.APP_NAME = 'Security';
const APP_ICON_SOLUTION = exports.APP_ICON_SOLUTION = 'logoSecurity';
const APP_PATH = exports.APP_PATH = `/app/security`;
const APP_INTEGRATIONS_PATH = exports.APP_INTEGRATIONS_PATH = `/app/integrations`;
const ADD_DATA_PATH = exports.ADD_DATA_PATH = `${APP_INTEGRATIONS_PATH}/browse/security`;
const ADD_THREAT_INTELLIGENCE_DATA_PATH = exports.ADD_THREAT_INTELLIGENCE_DATA_PATH = `${APP_INTEGRATIONS_PATH}/browse/threat_intel`;
const DEFAULT_BYTES_FORMAT = exports.DEFAULT_BYTES_FORMAT = 'format:bytes:defaultPattern';
const DEFAULT_DATE_FORMAT = exports.DEFAULT_DATE_FORMAT = 'dateFormat';
const DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT_TZ = 'dateFormat:tz';
const DEFAULT_INDEX_KEY = exports.DEFAULT_INDEX_KEY = 'securitySolution:defaultIndex';
const DEFAULT_NUMBER_FORMAT = exports.DEFAULT_NUMBER_FORMAT = 'format:number:defaultPattern';
const DEFAULT_DATA_VIEW_ID = exports.DEFAULT_DATA_VIEW_ID = 'security-solution';
const DEFAULT_ALERT_DATA_VIEW_ID = exports.DEFAULT_ALERT_DATA_VIEW_ID = 'security-solution-alert';
const DEFAULT_ATTACK_DATA_VIEW_ID = exports.DEFAULT_ATTACK_DATA_VIEW_ID = 'security-solution-attack';
const DEFAULT_TIME_FIELD = exports.DEFAULT_TIME_FIELD = '@timestamp';
const DEFAULT_TIME_RANGE = exports.DEFAULT_TIME_RANGE = 'timepicker:timeDefaults';
const DEFAULT_REFRESH_RATE_INTERVAL = exports.DEFAULT_REFRESH_RATE_INTERVAL = 'timepicker:refreshIntervalDefaults';
const DEFAULT_APP_TIME_RANGE = exports.DEFAULT_APP_TIME_RANGE = 'securitySolution:timeDefaults';
const DEFAULT_APP_REFRESH_INTERVAL = exports.DEFAULT_APP_REFRESH_INTERVAL = 'securitySolution:refreshIntervalDefaults';
const DEFAULT_ALERTS_INDEX = exports.DEFAULT_ALERTS_INDEX = '.alerts-security.alerts';
const DEFAULT_SIGNALS_INDEX = exports.DEFAULT_SIGNALS_INDEX = '.siem-signals';
const DEFAULT_PREVIEW_INDEX = exports.DEFAULT_PREVIEW_INDEX = '.preview.alerts-security.alerts';
const DEFAULT_LISTS_INDEX = exports.DEFAULT_LISTS_INDEX = '.lists';
const DEFAULT_ITEMS_INDEX = exports.DEFAULT_ITEMS_INDEX = '.items';
const DEFAULT_RISK_SCORE_PAGE_SIZE = exports.DEFAULT_RISK_SCORE_PAGE_SIZE = 1000;
// The DEFAULT_MAX_SIGNALS value exists also in `x-pack/platform/plugins/shared/cases/common/constants.ts`
// If either changes, engineer should ensure both values are updated
const DEFAULT_MAX_SIGNALS = exports.DEFAULT_MAX_SIGNALS = 100;
const DEFAULT_SEARCH_AFTER_PAGE_SIZE = exports.DEFAULT_SEARCH_AFTER_PAGE_SIZE = 100;
const DEFAULT_ANOMALY_SCORE = exports.DEFAULT_ANOMALY_SCORE = 'securitySolution:defaultAnomalyScore';
const DEFAULT_MAX_TABLE_QUERY_SIZE = exports.DEFAULT_MAX_TABLE_QUERY_SIZE = 10000;
const DEFAULT_FROM = exports.DEFAULT_FROM = 'now/d';
const DEFAULT_TO = exports.DEFAULT_TO = 'now/d';
const DEFAULT_INTERVAL_PAUSE = exports.DEFAULT_INTERVAL_PAUSE = true;
const DEFAULT_INTERVAL_TYPE = exports.DEFAULT_INTERVAL_TYPE = 'manual';
const DEFAULT_INTERVAL_VALUE = exports.DEFAULT_INTERVAL_VALUE = 300000; // ms
const DEFAULT_TIMEPICKER_QUICK_RANGES = exports.DEFAULT_TIMEPICKER_QUICK_RANGES = 'timepicker:quickRanges';
const SCROLLING_DISABLED_CLASS_NAME = exports.SCROLLING_DISABLED_CLASS_NAME = 'scrolling-disabled';
const NO_ALERT_INDEX = exports.NO_ALERT_INDEX = 'no-alert-index-049FC71A-4C2C-446F-9901-37XMC5024C51';
const ENDPOINT_METADATA_INDEX = exports.ENDPOINT_METADATA_INDEX = 'metrics-endpoint.metadata-*';
const ENDPOINT_METRICS_INDEX = exports.ENDPOINT_METRICS_INDEX = '.ds-metrics-endpoint.metrics-*';
const DEFAULT_RULE_REFRESH_INTERVAL_ON = exports.DEFAULT_RULE_REFRESH_INTERVAL_ON = true;
const DEFAULT_RULE_REFRESH_INTERVAL_VALUE = exports.DEFAULT_RULE_REFRESH_INTERVAL_VALUE = 60000; // ms
const DEFAULT_RULE_NOTIFICATION_QUERY_SIZE = exports.DEFAULT_RULE_NOTIFICATION_QUERY_SIZE = 100;
const SECURITY_TAG_NAME = exports.SECURITY_TAG_NAME = 'Security Solution';
const SECURITY_TAG_DESCRIPTION = exports.SECURITY_TAG_DESCRIPTION = 'Security Solution auto-generated tag';
const DEFAULT_SPACE_ID = exports.DEFAULT_SPACE_ID = 'default';
const DEFAULT_RELATIVE_DATE_THRESHOLD = exports.DEFAULT_RELATIVE_DATE_THRESHOLD = 24;

// Document path where threat indicator fields are expected. Fields are used
// to enrich signals, and are copied to threat.enrichments.
const DEFAULT_INDICATOR_SOURCE_PATH = exports.DEFAULT_INDICATOR_SOURCE_PATH = 'threat.indicator';
const ENRICHMENT_DESTINATION_PATH = exports.ENRICHMENT_DESTINATION_PATH = 'threat.enrichments';
const DEFAULT_THREAT_INDEX_KEY = exports.DEFAULT_THREAT_INDEX_KEY = 'securitySolution:defaultThreatIndex';
const DEFAULT_THREAT_INDEX_VALUE = exports.DEFAULT_THREAT_INDEX_VALUE = ['logs-ti_*'];
const DEFAULT_THREAT_MATCH_QUERY = exports.DEFAULT_THREAT_MATCH_QUERY = '@timestamp >= "now-30d/d"';
const EXPLORE_DATA_VIEW_PREFIX = exports.EXPLORE_DATA_VIEW_PREFIX = 'explore-data-view';
const EXPLORE_PATH = exports.EXPLORE_PATH = '/explore';
const DASHBOARDS_PATH = exports.DASHBOARDS_PATH = '/dashboards';
const MANAGE_PATH = exports.MANAGE_PATH = '/manage';
const TIMELINES_PATH = exports.TIMELINES_PATH = '/timelines';
const CASES_PATH = exports.CASES_PATH = '/cases';
const OVERVIEW_PATH = exports.OVERVIEW_PATH = '/overview';
const ONBOARDING_PATH = exports.ONBOARDING_PATH = '/get_started';
const DATA_QUALITY_PATH = exports.DATA_QUALITY_PATH = '/data_quality';
const REPORTS_PATH = exports.REPORTS_PATH = '/reports';
const AI_VALUE_PATH = exports.AI_VALUE_PATH = `${REPORTS_PATH}/ai_value`;
const DETECTION_RESPONSE_PATH = exports.DETECTION_RESPONSE_PATH = '/detection_response';
const DETECTIONS_PATH = exports.DETECTIONS_PATH = '/detections';

// TODO: https://github.com/elastic/kibana/issues/242434
// Investigate possibility of using `detections` instead
const ALERTS_PATH = exports.ALERTS_PATH = '/alerts';
const ATTACKS_PATH = exports.ATTACKS_PATH = '/attacks';
const ALERT_DETECTIONS = exports.ALERT_DETECTIONS = '/alert_detections';
const ALERT_DETAILS_REDIRECT_PATH = exports.ALERT_DETAILS_REDIRECT_PATH = `${ALERTS_PATH}/redirect`;
const ALERT_SUMMARY_PATH = exports.ALERT_SUMMARY_PATH = `/alert_summary`;
const RULES_PATH = exports.RULES_PATH = '/rules';
const RULES_LANDING_PATH = exports.RULES_LANDING_PATH = `${RULES_PATH}/landing`;
const RULES_ADD_PATH = exports.RULES_ADD_PATH = `${RULES_PATH}/add_rules`;
const RULES_UPDATES = exports.RULES_UPDATES = `${RULES_PATH}/updates`;
const RULES_CREATE_PATH = exports.RULES_CREATE_PATH = `${RULES_PATH}/create`;
const EXCEPTIONS_PATH = exports.EXCEPTIONS_PATH = '/exceptions';
const EXCEPTION_LIST_DETAIL_PATH = exports.EXCEPTION_LIST_DETAIL_PATH = `${EXCEPTIONS_PATH}/details/:detailName`;
const HOSTS_PATH = exports.HOSTS_PATH = '/hosts';
const ATTACK_DISCOVERY_PATH = exports.ATTACK_DISCOVERY_PATH = '/attack_discovery';
const ASSET_INVENTORY_PATH = exports.ASSET_INVENTORY_PATH = '/asset_inventory';
const SIEM_READINESS_PATH = exports.SIEM_READINESS_PATH = '/siem_readiness';
const USERS_PATH = exports.USERS_PATH = '/users';
const KUBERNETES_PATH = exports.KUBERNETES_PATH = '/kubernetes';
const NETWORK_PATH = exports.NETWORK_PATH = '/network';
const MANAGEMENT_PATH = exports.MANAGEMENT_PATH = '/administration';
const COVERAGE_OVERVIEW_PATH = exports.COVERAGE_OVERVIEW_PATH = '/rules_coverage_overview';
const THREAT_INTELLIGENCE_PATH = exports.THREAT_INTELLIGENCE_PATH = '/threat_intelligence';
const ENDPOINTS_PATH = exports.ENDPOINTS_PATH = `${MANAGEMENT_PATH}/endpoints`;
const POLICIES_PATH = exports.POLICIES_PATH = `${MANAGEMENT_PATH}/policy`;
const ENDPOINT_EXCEPTIONS_PATH = exports.ENDPOINT_EXCEPTIONS_PATH = `${MANAGEMENT_PATH}/endpoint_exceptions`;
const TRUSTED_APPS_PATH = exports.TRUSTED_APPS_PATH = `${MANAGEMENT_PATH}/trusted_apps`;
const TRUSTED_DEVICES_PATH = exports.TRUSTED_DEVICES_PATH = `${MANAGEMENT_PATH}/trusted_devices`;
const EVENT_FILTERS_PATH = exports.EVENT_FILTERS_PATH = `${MANAGEMENT_PATH}/event_filters`;
const HOST_ISOLATION_EXCEPTIONS_PATH = exports.HOST_ISOLATION_EXCEPTIONS_PATH = `${MANAGEMENT_PATH}/host_isolation_exceptions`;
const BLOCKLIST_PATH = exports.BLOCKLIST_PATH = `${MANAGEMENT_PATH}/blocklist`;
const RESPONSE_ACTIONS_HISTORY_PATH = exports.RESPONSE_ACTIONS_HISTORY_PATH = `${MANAGEMENT_PATH}/response_actions_history`;
const ENTITY_ANALYTICS_PATH = exports.ENTITY_ANALYTICS_PATH = '/entity_analytics';
const ENTITY_ANALYTICS_MANAGEMENT_PATH = exports.ENTITY_ANALYTICS_MANAGEMENT_PATH = `/entity_analytics_management`;
const ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH = exports.ENTITY_ANALYTICS_ASSET_CRITICALITY_PATH = `/entity_analytics_asset_criticality`;
const ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH = exports.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH = `/entity_analytics_entity_store`;
const ENTITY_ANALYTICS_LANDING_PATH = exports.ENTITY_ANALYTICS_LANDING_PATH = '/entity_analytics_landing';
const ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH = exports.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH = '/entity_analytics_privileged_user_monitoring';
const ENTITY_ANALYTICS_OVERVIEW_PATH = exports.ENTITY_ANALYTICS_OVERVIEW_PATH = `/entity_analytics_overview`;
const APP_ALERTS_PATH = exports.APP_ALERTS_PATH = `${APP_PATH}${ALERTS_PATH}`;
const APP_CASES_PATH = exports.APP_CASES_PATH = `${APP_PATH}${CASES_PATH}`;
const APP_ENDPOINTS_PATH = exports.APP_ENDPOINTS_PATH = `${APP_PATH}${ENDPOINTS_PATH}`;
const APP_POLICIES_PATH = exports.APP_POLICIES_PATH = `${APP_PATH}${POLICIES_PATH}`;
const APP_ENDPOINT_EXCEPTIONS_PATH = exports.APP_ENDPOINT_EXCEPTIONS_PATH = `${APP_PATH}${ENDPOINT_EXCEPTIONS_PATH}`;
const APP_MANAGE_PATH = exports.APP_MANAGE_PATH = `${APP_PATH}${MANAGE_PATH}`;
const APP_TRUSTED_APPS_PATH = exports.APP_TRUSTED_APPS_PATH = `${APP_PATH}${TRUSTED_APPS_PATH}`;
const APP_TRUSTED_DEVICES_PATH = exports.APP_TRUSTED_DEVICES_PATH = `${APP_PATH}${TRUSTED_DEVICES_PATH}`;
const APP_EVENT_FILTERS_PATH = exports.APP_EVENT_FILTERS_PATH = `${APP_PATH}${EVENT_FILTERS_PATH}`;
const APP_HOST_ISOLATION_EXCEPTIONS_PATH = exports.APP_HOST_ISOLATION_EXCEPTIONS_PATH = `${APP_PATH}${HOST_ISOLATION_EXCEPTIONS_PATH}`;
const APP_BLOCKLIST_PATH = exports.APP_BLOCKLIST_PATH = `${APP_PATH}${BLOCKLIST_PATH}`;
const APP_RESPONSE_ACTIONS_HISTORY_PATH = exports.APP_RESPONSE_ACTIONS_HISTORY_PATH = `${APP_PATH}${RESPONSE_ACTIONS_HISTORY_PATH}`;
const NOTES_PATH = exports.NOTES_PATH = `${MANAGEMENT_PATH}/notes`;
const SIEM_MIGRATIONS_PATH = exports.SIEM_MIGRATIONS_PATH = '/siem_migrations';
const SIEM_MIGRATIONS_LANDING_PATH = exports.SIEM_MIGRATIONS_LANDING_PATH = `${SIEM_MIGRATIONS_PATH}/landing`;
const SIEM_MIGRATIONS_RULES_PATH = exports.SIEM_MIGRATIONS_RULES_PATH = `${SIEM_MIGRATIONS_PATH}/rules`;
const SIEM_MIGRATIONS_DASHBOARDS_PATH = exports.SIEM_MIGRATIONS_DASHBOARDS_PATH = `${SIEM_MIGRATIONS_PATH}/dashboards`;

// EASE exclusive paths
const CONFIGURATIONS_PATH = exports.CONFIGURATIONS_PATH = '/configurations';
const CONFIGURATIONS_INTEGRATIONS_PATH = exports.CONFIGURATIONS_INTEGRATIONS_PATH = `${APP_PATH}/${CONFIGURATIONS_PATH}/integrations/browse`;

// cloud logs to exclude from default index pattern
const EXCLUDE_ELASTIC_CLOUD_INDICES = exports.EXCLUDE_ELASTIC_CLOUD_INDICES = ['-*elastic-cloud-logs-*'];

/** The comma-delimited list of Elasticsearch indices from which the SIEM app collects events */
const INCLUDE_INDEX_PATTERN = exports.INCLUDE_INDEX_PATTERN = ['apm-*-transaction*', 'auditbeat-*', 'endgame-*', 'filebeat-*', 'logs-*', 'packetbeat-*', 'traces-apm*', 'winlogbeat-*'];
/** The comma-delimited list of Elasticsearch indices from which the SIEM app collects events, and the exclude index pattern */
const DEFAULT_INDEX_PATTERN = exports.DEFAULT_INDEX_PATTERN = [...INCLUDE_INDEX_PATTERN, ...EXCLUDE_ELASTIC_CLOUD_INDICES];

/** This Kibana Advanced Setting enables the `Security news` feed widget */
const ENABLE_NEWS_FEED_SETTING = exports.ENABLE_NEWS_FEED_SETTING = 'securitySolution:enableNewsFeed';

/** This Kibana Advanced Setting sets a default AI connector for serverless AI features (EASE) */
const DEFAULT_AI_CONNECTOR = exports.DEFAULT_AI_CONNECTOR = 'securitySolution:defaultAIConnector';

/** This Kibana Advanced Setting allows users to enable/disable querying cold and frozen data tiers in analyzer */
const EXCLUDE_COLD_AND_FROZEN_TIERS_IN_ANALYZER = exports.EXCLUDE_COLD_AND_FROZEN_TIERS_IN_ANALYZER = 'securitySolution:excludeColdAndFrozenTiersInAnalyzer';

/** This Kibana Advanced Setting enables the warnings for CCS read permissions */
const ENABLE_CCS_READ_WARNING_SETTING = exports.ENABLE_CCS_READ_WARNING_SETTING = 'securitySolution:enableCcsWarning';

/** This Kibana Advanced Setting when turned on keeps the suppression window open when an alert is closed */
const SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING = exports.SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING = 'securitySolution:suppressionBehaviorOnAlertClosure';
let SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM = exports.SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM = /*#__PURE__*/function (SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM) {
  SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM["RestartWindow"] = "restart-suppression";
  SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM["ContinueWindow"] = "continue-until-window-ends";
  return SUPPRESSION_BEHAVIOR_ON_ALERT_CLOSURE_SETTING_ENUM;
}({});
/** This Kibana Advanced Setting sets the auto refresh interval for the detections all rules table */
const DEFAULT_RULES_TABLE_REFRESH_SETTING = exports.DEFAULT_RULES_TABLE_REFRESH_SETTING = 'securitySolution:rulesTableRefresh';

/** This Kibana Advanced Setting specifies the URL of the News feed widget */
const NEWS_FEED_URL_SETTING = exports.NEWS_FEED_URL_SETTING = 'securitySolution:newsFeedUrl';

/** The default value for News feed widget */
const NEWS_FEED_URL_SETTING_DEFAULT = exports.NEWS_FEED_URL_SETTING_DEFAULT = 'https://feeds.elastic.co/security-solution';

/** This Kibana Advanced Setting specifies the URLs of `IP Reputation Links`*/
const IP_REPUTATION_LINKS_SETTING = exports.IP_REPUTATION_LINKS_SETTING = 'securitySolution:ipReputationLinks';

/** The default value for `IP Reputation Links` */
const IP_REPUTATION_LINKS_SETTING_DEFAULT = exports.IP_REPUTATION_LINKS_SETTING_DEFAULT = `[
  { "name": "virustotal.com", "url_template": "https://www.virustotal.com/gui/search/{{ip}}" },
  { "name": "talosIntelligence.com", "url_template": "https://talosintelligence.com/reputation_center/lookup?search={{ip}}" }
]`;

/** This Kibana Advanced Setting shows related integrations on the Rules Table */
const SHOW_RELATED_INTEGRATIONS_SETTING = exports.SHOW_RELATED_INTEGRATIONS_SETTING = 'securitySolution:showRelatedIntegrations';

/** This Kibana Advanced Setting enables extended rule execution logging to Event Log */
const EXTENDED_RULE_EXECUTION_LOGGING_ENABLED_SETTING = exports.EXTENDED_RULE_EXECUTION_LOGGING_ENABLED_SETTING = 'securitySolution:extendedRuleExecutionLoggingEnabled';

/** This Kibana Advanced Setting sets minimum log level starting from which execution logs will be written to Event Log */
const EXTENDED_RULE_EXECUTION_LOGGING_MIN_LEVEL_SETTING = exports.EXTENDED_RULE_EXECUTION_LOGGING_MIN_LEVEL_SETTING = 'securitySolution:extendedRuleExecutionLoggingMinLevel';

/** This Kibana Advanced Setting allows users to exclude selected data tiers from search during rule execution */
const EXCLUDED_DATA_TIERS_FOR_RULE_EXECUTION = exports.EXCLUDED_DATA_TIERS_FOR_RULE_EXECUTION = 'securitySolution:excludedDataTiersForRuleExecution';

/** This Kibana Advanced Setting allows users to enable/disable the Graph Visualizations for alerts and events */
const ENABLE_GRAPH_VISUALIZATION_SETTING = exports.ENABLE_GRAPH_VISUALIZATION_SETTING = 'securitySolution:enableGraphVisualization';

/** This Kibana Advanced Setting allows users to enable/disable the Asset Inventory feature */
const ENABLE_ASSET_INVENTORY_SETTING = exports.ENABLE_ASSET_INVENTORY_SETTING = 'securitySolution:enableAssetInventory';

/** This Kibana Advanced Setting allows users to enable/disable the Cloud Connector Feature */
const ENABLE_CLOUD_CONNECTOR_SETTING = exports.ENABLE_CLOUD_CONNECTOR_SETTING = 'securitySolution:enableCloudConnector';

/** This Kibana Advanced Setting allows users to enable/disable the SIEM Readiness Feature */
const ENABLE_SIEM_READINESS_SETTING = exports.ENABLE_SIEM_READINESS_SETTING = 'securitySolution:enableSiemReadiness';

/** This Kibana Advanced Setting allows users to enable/disable the privilged user monitoring feature */
const ENABLE_PRIVILEGED_USER_MONITORING_SETTING = exports.ENABLE_PRIVILEGED_USER_MONITORING_SETTING = 'securitySolution:enablePrivilegedUserMonitoring';

/** This Kibana Advanced Setting allows users to enable/disable ESQL-based risk scoring */
const ENABLE_ESQL_RISK_SCORING = exports.ENABLE_ESQL_RISK_SCORING = 'securitySolution:enableEsqlRiskScoring';

/**
 * Id for the notifications alerting type
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 */
const LEGACY_NOTIFICATIONS_ID = exports.LEGACY_NOTIFICATIONS_ID = `siem.notifications`;

/**
 * Internal actions route
 */
const UPDATE_OR_CREATE_LEGACY_ACTIONS = exports.UPDATE_OR_CREATE_LEGACY_ACTIONS = '/internal/api/detection/legacy/notifications';

/**
 * Exceptions management routes
 */
const SHARED_EXCEPTION_LIST_URL = exports.SHARED_EXCEPTION_LIST_URL = `/api${EXCEPTIONS_PATH}/shared`;

/**
 * Detection engine routes
 */
const DETECTION_ENGINE_URL = exports.DETECTION_ENGINE_URL = '/api/detection_engine';
const DETECTION_ENGINE_PRIVILEGES_URL = exports.DETECTION_ENGINE_PRIVILEGES_URL = `${DETECTION_ENGINE_URL}/privileges`;
const DETECTION_ENGINE_INDEX_URL = exports.DETECTION_ENGINE_INDEX_URL = `${DETECTION_ENGINE_URL}/index`;
const DETECTION_ENGINE_RULES_URL = exports.DETECTION_ENGINE_RULES_URL = `${DETECTION_ENGINE_URL}/rules`;
const DETECTION_ENGINE_RULES_URL_FIND = exports.DETECTION_ENGINE_RULES_URL_FIND = `${DETECTION_ENGINE_RULES_URL}/_find`;
const DETECTION_ENGINE_TAGS_URL = exports.DETECTION_ENGINE_TAGS_URL = `${DETECTION_ENGINE_URL}/tags`;
const DETECTION_ENGINE_RULES_BULK_ACTION = exports.DETECTION_ENGINE_RULES_BULK_ACTION = `${DETECTION_ENGINE_RULES_URL}/_bulk_action`;
const DETECTION_ENGINE_RULES_PREVIEW = exports.DETECTION_ENGINE_RULES_PREVIEW = `${DETECTION_ENGINE_RULES_URL}/preview`;
const DETECTION_ENGINE_RULES_IMPORT_URL = exports.DETECTION_ENGINE_RULES_IMPORT_URL = `${DETECTION_ENGINE_RULES_URL}/_import`;
const INTERNAL_DASHBOARDS_URL = exports.INTERNAL_DASHBOARDS_URL = `/internal/dashboards`;
const INTERNAL_TAGS_URL = exports.INTERNAL_TAGS_URL = `/internal/tags`;

/**
 * Internal detection engine routes
 */
const INTERNAL_DETECTION_ENGINE_URL = exports.INTERNAL_DETECTION_ENGINE_URL = '/internal/detection_engine';
const DETECTION_ENGINE_ALERTS_INDEX_URL = exports.DETECTION_ENGINE_ALERTS_INDEX_URL = `${INTERNAL_DETECTION_ENGINE_URL}/signal/index`;
const DETECTION_ENGINE_ALERT_SUGGEST_USERS_URL = exports.DETECTION_ENGINE_ALERT_SUGGEST_USERS_URL = `${INTERNAL_DETECTION_ENGINE_URL}/users/_find`;

/**
 * Telemetry detection endpoint for any previews requested of what data we are
 * providing through UI/UX and for e2e tests.
 *   curl http//localhost:5601/internal/security_solution/telemetry
 * to see the contents
 */
const SECURITY_TELEMETRY_URL = exports.SECURITY_TELEMETRY_URL = `/internal/security_solution/telemetry`;
const TIMELINE_RESOLVE_URL = exports.TIMELINE_RESOLVE_URL = '/api/timeline/resolve';
const TIMELINE_URL = exports.TIMELINE_URL = '/api/timeline';
const TIMELINES_URL = exports.TIMELINES_URL = '/api/timelines';
const TIMELINE_FAVORITE_URL = exports.TIMELINE_FAVORITE_URL = '/api/timeline/_favorite';
const TIMELINE_DRAFT_URL = exports.TIMELINE_DRAFT_URL = `${TIMELINE_URL}/_draft`;
const TIMELINE_EXPORT_URL = exports.TIMELINE_EXPORT_URL = `${TIMELINE_URL}/_export`;
const TIMELINE_IMPORT_URL = exports.TIMELINE_IMPORT_URL = `${TIMELINE_URL}/_import`;
const TIMELINE_PREPACKAGED_URL = exports.TIMELINE_PREPACKAGED_URL = `${TIMELINE_URL}/_prepackaged`;
const TIMELINE_COPY_URL = exports.TIMELINE_COPY_URL = `${TIMELINE_URL}/_copy`;
const NOTE_URL = exports.NOTE_URL = '/api/note';
const PINNED_EVENT_URL = exports.PINNED_EVENT_URL = '/api/pinned_event';

/**
 * This limit exists to maintain some kind of a safety net for how many events we are fetching in total,
 * even though in theory we are only allowing up to 100 notes per document.
 */
const NOTES_PER_PAGE_HARD_LIMIT = exports.NOTES_PER_PAGE_HARD_LIMIT = 10000;

/**
 * Default signals index key for kibana.dev.yml
 */
const SIGNALS_INDEX_KEY = exports.SIGNALS_INDEX_KEY = 'signalsIndex';
const DETECTION_ENGINE_SIGNALS_URL = exports.DETECTION_ENGINE_SIGNALS_URL = `${DETECTION_ENGINE_URL}/signals`;
const DETECTION_ENGINE_SIGNALS_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_STATUS_URL = `${DETECTION_ENGINE_SIGNALS_URL}/status`;
const DETECTION_ENGINE_QUERY_SIGNALS_URL = exports.DETECTION_ENGINE_QUERY_SIGNALS_URL = `${DETECTION_ENGINE_SIGNALS_URL}/search`;
const DETECTION_ENGINE_SIGNALS_MIGRATION_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_URL = `${DETECTION_ENGINE_SIGNALS_URL}/migration`;
const DETECTION_ENGINE_SIGNALS_MIGRATION_STATUS_URL = exports.DETECTION_ENGINE_SIGNALS_MIGRATION_STATUS_URL = `${DETECTION_ENGINE_SIGNALS_URL}/migration_status`;
const DETECTION_ENGINE_SIGNALS_FINALIZE_MIGRATION_URL = exports.DETECTION_ENGINE_SIGNALS_FINALIZE_MIGRATION_URL = `${DETECTION_ENGINE_SIGNALS_URL}/finalize_migration`;
const DETECTION_ENGINE_ALERT_TAGS_URL = exports.DETECTION_ENGINE_ALERT_TAGS_URL = `${DETECTION_ENGINE_SIGNALS_URL}/tags`;
const DETECTION_ENGINE_ALERT_ASSIGNEES_URL = exports.DETECTION_ENGINE_ALERT_ASSIGNEES_URL = `${DETECTION_ENGINE_SIGNALS_URL}/assignees`;
const ALERTS_AS_DATA_URL = exports.ALERTS_AS_DATA_URL = '/internal/rac/alerts';
const ALERTS_AS_DATA_FIND_URL = exports.ALERTS_AS_DATA_FIND_URL = `${ALERTS_AS_DATA_URL}/find`;

/**
 * Security Integrations routes
 */
const SECRUTIY_INTEGRATIONS_FLEET_MANAGED_INDEX_TEMPLATES_URL = exports.SECRUTIY_INTEGRATIONS_FLEET_MANAGED_INDEX_TEMPLATES_URL = '/internal/fleet_index_templates';
const SECURITY_INTEGRATIONS_CRIBL_ROUTING_PIPELINE = exports.SECURITY_INTEGRATIONS_CRIBL_ROUTING_PIPELINE = 'cribl-routing-pipeline';

/**
 * Common naming convention for an unauthenticated user
 */
const UNAUTHENTICATED_USER = exports.UNAUTHENTICATED_USER = 'Unauthenticated';

/**
 Licensing requirements
 */
const MINIMUM_ML_LICENSE = exports.MINIMUM_ML_LICENSE = 'platinum';
const MINIMUM_RULE_CUSTOMIZATION_LICENSE = exports.MINIMUM_RULE_CUSTOMIZATION_LICENSE = 'enterprise';

/**
 Machine Learning constants
 */
const ML_GROUP_ID = exports.ML_GROUP_ID = 'security';
const LEGACY_ML_GROUP_ID = exports.LEGACY_ML_GROUP_ID = 'siem';
const ML_GROUP_IDS = exports.ML_GROUP_IDS = [ML_GROUP_ID, LEGACY_ML_GROUP_ID];

/**
 * Rule Actions
 */
const NOTIFICATION_THROTTLE_NO_ACTIONS = exports.NOTIFICATION_THROTTLE_NO_ACTIONS = 'no_actions';
const NOTIFICATION_THROTTLE_RULE = exports.NOTIFICATION_THROTTLE_RULE = 'rule';
const NOTIFICATION_DEFAULT_FREQUENCY = exports.NOTIFICATION_DEFAULT_FREQUENCY = {
  notifyWhen: _common.RuleNotifyWhen.ACTIVE,
  throttle: null,
  summary: true
};
const TRANSFORM_STATES = exports.TRANSFORM_STATES = {
  ABORTING: 'aborting',
  FAILED: 'failed',
  INDEXING: 'indexing',
  STARTED: 'started',
  STOPPED: 'stopped',
  STOPPING: 'stopping',
  WAITING: 'waiting'
};
const WARNING_TRANSFORM_STATES = exports.WARNING_TRANSFORM_STATES = new Set([TRANSFORM_STATES.ABORTING, TRANSFORM_STATES.FAILED, TRANSFORM_STATES.STOPPED, TRANSFORM_STATES.STOPPING]);
const STARTED_TRANSFORM_STATES = exports.STARTED_TRANSFORM_STATES = new Set([TRANSFORM_STATES.INDEXING, TRANSFORM_STATES.STARTED]);

/**
 * How many rules to update at a time is set to 20 from errors coming from
 * the slow environments such as cloud when the rule updates are > 100 we were
 * seeing timeout issues.
 *
 * Since there is not timeout options at the alerting API level right now, we are
 * at the mercy of the Elasticsearch server client/server default timeouts and what
 * we are doing could be considered a workaround to not being able to increase the timeouts.
 *
 * However, other bad effects and saturation of connections beyond 50 makes this a "noisy neighbor"
 * if we don't limit its number of connections as we increase the number of rules that can be
 * installed at a time.
 *
 * Lastly, we saw weird issues where Chrome on upstream 408 timeouts will re-call the REST route
 * which in turn could create additional connections we want to avoid.
 *
 * See file import_rules_route.ts for another area where 20 was chosen, therefore I chose
 * 20 here to mimic it as well. If you see this re-opened or what similar to it, consider
 * reducing the 20 above to a lower number.
 *
 * See the original ticket here:
 * https://github.com/elastic/kibana/issues/94418
 */
const MAX_RULES_TO_UPDATE_IN_PARALLEL = exports.MAX_RULES_TO_UPDATE_IN_PARALLEL = 20;
const LIMITED_CONCURRENCY_ROUTE_TAG_PREFIX = exports.LIMITED_CONCURRENCY_ROUTE_TAG_PREFIX = `${APP_ID}:limitedConcurrency`;

/**
 * Max number of rules to display on UI in table, max number of rules that can be edited in a single bulk edit API request
 * We limit number of rules in bulk edit API, because rulesClient doesn't support bulkGet of rules by ids.
 * Given this limitation, current implementation fetches each rule separately through rulesClient.resolve method.
 * As max number of rules displayed on a page is 100, max 100 rules can be bulk edited by passing their ids to API.
 * We decided add this limit(number of ids less than 100) in bulk edit API as well, to prevent a huge number of single rule fetches
 */
const RULES_TABLE_MAX_PAGE_SIZE = exports.RULES_TABLE_MAX_PAGE_SIZE = 100;

/**
 * Local storage keys we use to store the state of our new features tours we currently show in the app.
 *
 * NOTE: As soon as we want to show tours for new features in the upcoming release,
 * we will need to update these constants with the corresponding version.
 */
const NEW_FEATURES_TOUR_STORAGE_KEYS = exports.NEW_FEATURES_TOUR_STORAGE_KEYS = {
  RULE_MANAGEMENT_PAGE: 'securitySolution.rulesManagementPage.newFeaturesTour.v9.2',
  TIMELINES: 'securitySolution.security.timelineFlyoutHeader.saveTimelineTour',
  SIEM_MAIN_LANDING_PAGE: 'securitySolution.siemMigrations.setupGuide.v8.18',
  SIEM_RULE_TRANSLATION_PAGE: 'securitySolution.siemMigrations.ruleTranslationGuide.v8.18',
  DEFAULT_LLM: `elasticAssistant.elasticLLM.costAwarenessTour.assistantHeader.v8.19.default`
};
const RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_METRIC_COLUMNS_STORAGE_KEY = exports.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_METRIC_COLUMNS_STORAGE_KEY = 'securitySolution.ruleDetails.ruleExecutionLog.showMetrics.v8.2';
const RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_SOURCE_EVENT_TIME_RANGE_STORAGE_KEY = exports.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_SOURCE_EVENT_TIME_RANGE_STORAGE_KEY = 'securitySolution.ruleDetails.ruleExecutionLog.showSourceEventTimeRange.v8.15';
const MAX_NUMBER_OF_NEW_TERMS_FIELDS = exports.MAX_NUMBER_OF_NEW_TERMS_FIELDS = 3;
const BULK_ADD_TO_TIMELINE_LIMIT = exports.BULK_ADD_TO_TIMELINE_LIMIT = 2000;
const DEFAULT_DETECTION_PAGE_FILTERS = exports.DEFAULT_DETECTION_PAGE_FILTERS = [{
  title: 'Status',
  fieldName: 'kibana.alert.workflow_status',
  selectedOptions: ['open'],
  hideActionBar: true,
  persist: true,
  hideExists: true
}, {
  title: 'Severity',
  fieldName: 'kibana.alert.severity',
  selectedOptions: [],
  hideActionBar: true,
  hideExists: true
}, {
  title: 'User',
  fieldName: 'user.name'
}, {
  title: 'Host',
  fieldName: 'host.name'
}];

/** This local storage key stores the `Grid / Event rendered view` selection */
const ALERTS_TABLE_VIEW_SELECTION_KEY = exports.ALERTS_TABLE_VIEW_SELECTION_KEY = 'securitySolution.alerts.table.view-selection';
const VIEW_SELECTION = exports.VIEW_SELECTION = {
  gridView: 'gridView',
  eventRenderedView: 'eventRenderedView'
};
const ALERTS_TABLE_REGISTRY_CONFIG_IDS = exports.ALERTS_TABLE_REGISTRY_CONFIG_IDS = {
  ALERTS_PAGE: `${APP_ID}-alerts-page`,
  RULE_DETAILS: `${APP_ID}-rule-details`,
  CASE: `${APP_ID}-case`,
  RISK_INPUTS: `${APP_ID}-risk-inputs`
};
const DEFAULT_ALERT_TAGS_KEY = exports.DEFAULT_ALERT_TAGS_KEY = 'securitySolution:alertTags';
const DEFAULT_ALERT_TAGS_VALUE = exports.DEFAULT_ALERT_TAGS_VALUE = [i18n.DUPLICATE, i18n.FALSE_POSITIVE, i18n.FURTHER_INVESTIGATION_REQUIRED];

/**
 * Max length for the comments within security solution
 */
const MAX_COMMENT_LENGTH = exports.MAX_COMMENT_LENGTH = 30000;

/**
 * Max notes count per document in security solution
 */
const MAX_NOTES_PER_DOCUMENT = exports.MAX_NOTES_PER_DOCUMENT = 100;

/**
 * Cases external attachment IDs
 */
const CASE_ATTACHMENT_ENDPOINT_TYPE_ID = exports.CASE_ATTACHMENT_ENDPOINT_TYPE_ID = 'endpoint';

/**
 * Rule gaps
 */
const MAX_MANUAL_RULE_RUN_LOOKBACK_WINDOW_DAYS = exports.MAX_MANUAL_RULE_RUN_LOOKBACK_WINDOW_DAYS = 90;
const MAX_MANUAL_RULE_RUN_BULK_SIZE = exports.MAX_MANUAL_RULE_RUN_BULK_SIZE = 100;
const MAX_BULK_FILL_RULE_GAPS_LOOKBACK_WINDOW_DAYS = exports.MAX_BULK_FILL_RULE_GAPS_LOOKBACK_WINDOW_DAYS = 90;
const MAX_BULK_FILL_RULE_GAPS_BULK_SIZE = exports.MAX_BULK_FILL_RULE_GAPS_BULK_SIZE = 100;

/*
 * Whether it is a Jest environment
 */
const JEST_ENVIRONMENT = exports.JEST_ENVIRONMENT = typeof jest !== 'undefined';

/*
 * The tag to mark promotion rules that are related to EASE integrations
 */
const PROMOTION_RULE_TAGS = exports.PROMOTION_RULE_TAGS = ['Promotion',
// This is the legacy tag for promotion rules and can be safely removed once promotion rules go live
'Promotion: External Alerts'];