"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSecurityV4SubFeaturesMap = exports.getSecurityV4BaseKibanaSubFeatureIds = void 0;
var _product_features_keys = require("../../product_features_keys");
var _kibana_sub_features = require("../kibana_sub_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sub-features that will always be available for Security
 * regardless of the product type.
 */
const getSecurityV4BaseKibanaSubFeatureIds = ({
  experimentalFeatures
}) => [];

/**
 * Defines all the Security Assistant subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getSecurityV4BaseKibanaSubFeatureIds = getSecurityV4BaseKibanaSubFeatureIds;
const getSecurityV4SubFeaturesMap = ({
  experimentalFeatures
}) => {
  const securitySubFeaturesList = [[_product_features_keys.SecuritySubFeatureId.endpointList, (0, _kibana_sub_features.endpointListSubFeature)()], [_product_features_keys.SecuritySubFeatureId.workflowInsights, (0, _kibana_sub_features.workflowInsightsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.socManagement, (0, _kibana_sub_features.socManagementSubFeature)()], [_product_features_keys.SecuritySubFeatureId.globalArtifactManagement, (0, _kibana_sub_features.globalArtifactManagementSubFeature)(experimentalFeatures)], [_product_features_keys.SecuritySubFeatureId.trustedApplications, (0, _kibana_sub_features.trustedApplicationsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.trustedDevices, (0, _kibana_sub_features.trustedDevicesSubFeature)()], [_product_features_keys.SecuritySubFeatureId.hostIsolationExceptionsBasic, (0, _kibana_sub_features.hostIsolationExceptionsBasicSubFeature)()], [_product_features_keys.SecuritySubFeatureId.blocklist, (0, _kibana_sub_features.blocklistSubFeature)()], [_product_features_keys.SecuritySubFeatureId.eventFilters, (0, _kibana_sub_features.eventFiltersSubFeature)()], [_product_features_keys.SecuritySubFeatureId.endpointExceptions, (0, _kibana_sub_features.endpointExceptionsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.policyManagement, (0, _kibana_sub_features.policyManagementSubFeature)()], [_product_features_keys.SecuritySubFeatureId.responseActionsHistory, (0, _kibana_sub_features.responseActionsHistorySubFeature)()], [_product_features_keys.SecuritySubFeatureId.hostIsolation, (0, _kibana_sub_features.hostIsolationSubFeature)()], [_product_features_keys.SecuritySubFeatureId.processOperations, (0, _kibana_sub_features.processOperationsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.fileOperations, (0, _kibana_sub_features.fileOperationsSubFeature)()], [_product_features_keys.SecuritySubFeatureId.executeAction, (0, _kibana_sub_features.executeActionSubFeature)()], [_product_features_keys.SecuritySubFeatureId.scanAction, (0, _kibana_sub_features.scanActionSubFeature)()]];
  const securitySubFeaturesMap = new Map(securitySubFeaturesList.map(([id, originalSubFeature]) => {
    let subFeature = originalSubFeature;

    // Space awareness is now always enabled - set requireAllSpaces to false and remove privilegesTooltip
    subFeature = {
      ...subFeature,
      requireAllSpaces: false,
      privilegesTooltip: undefined
    };
    return [id, subFeature];
  }));

  // Remove disabled experimental features
  if (!experimentalFeatures.trustedDevices) {
    securitySubFeaturesMap.delete(_product_features_keys.SecuritySubFeatureId.trustedDevices);
  }
  return Object.freeze(securitySubFeaturesMap);
};
exports.getSecurityV4SubFeaturesMap = getSecurityV4SubFeaturesMap;