"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityDefaultProductFeaturesConfig = void 0;
var _product_features_keys = require("../product_features_keys");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const securityDefaultProductFeaturesConfig = exports.securityDefaultProductFeaturesConfig = {
  [_product_features_keys.ProductFeatureSecurityKey.advancedInsights]: {
    privileges: {
      all: {
        ui: ['entity-analytics'],
        api: [`${_constants.APP_ID}-entity-analytics`]
      },
      read: {
        ui: ['entity-analytics'],
        api: [`${_constants.APP_ID}-entity-analytics`]
      }
    }
  },
  [_product_features_keys.ProductFeatureSecurityKey.externalDetections]: {
    privileges: {
      all: {
        ui: ['external_detections'],
        api: []
      },
      read: {
        ui: ['external_detections'],
        api: []
      }
    }
  },
  [_product_features_keys.ProductFeatureSecurityKey.detections]: {
    privileges: {
      all: {
        ui: ['detections'],
        api: ['cloud-security-posture-all', 'cloud-security-posture-read', 'cloud-defend-all', 'cloud-defend-read', 'bulkGetUserProfiles']
      },
      read: {
        ui: ['detections'],
        api: ['cloud-security-posture-read', 'cloud-defend-read', 'bulkGetUserProfiles']
      }
    }
  },
  [_product_features_keys.ProductFeatureSecurityKey.investigationGuide]: {
    privileges: {
      all: {
        ui: ['investigation-guide']
      },
      read: {
        ui: ['investigation-guide']
      }
    }
  },
  [_product_features_keys.ProductFeatureSecurityKey.configurations]: {
    privileges: {
      all: {
        ui: ['configurations'],
        api: []
      },
      read: {
        ui: [],
        api: []
      }
    }
  },
  [_product_features_keys.ProductFeatureSecurityKey.aiValueReport]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.socManagement]
  },
  [_product_features_keys.ProductFeatureSecurityKey.investigationGuideInteractions]: {
    privileges: {
      all: {
        ui: ['investigation-guide-interactions']
      },
      read: {
        ui: ['investigation-guide-interactions']
      }
    }
  },
  [_product_features_keys.ProductFeatureSecurityKey.threatIntelligence]: {
    privileges: {
      all: {
        ui: ['threat-intelligence'],
        api: [`${_constants.APP_ID}-threat-intelligence`]
      },
      read: {
        ui: ['threat-intelligence'],
        api: [`${_constants.APP_ID}-threat-intelligence`]
      }
    }
  },
  [_product_features_keys.ProductFeatureSecurityKey.endpointHostIsolation]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.hostIsolation]
  },
  [_product_features_keys.ProductFeatureSecurityKey.endpointHostManagement]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.endpointList]
  },
  [_product_features_keys.ProductFeatureSecurityKey.endpointTrustedDevices]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.trustedDevices]
  },
  [_product_features_keys.ProductFeatureSecurityKey.endpointPolicyManagement]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.policyManagement]
  },
  // Adds no additional kibana feature controls
  [_product_features_keys.ProductFeatureSecurityKey.endpointPolicyProtections]: {},
  // Endpoint Complete Tier:
  // Allows access to create/update HIEs
  [_product_features_keys.ProductFeatureSecurityKey.endpointHostIsolationExceptions]: {
    subFeaturesPrivileges: [{
      id: 'host_isolation_exceptions_all',
      api: [`${_constants.APP_ID}-accessHostIsolationExceptions`, `${_constants.APP_ID}-writeHostIsolationExceptions`],
      ui: ['accessHostIsolationExceptions', 'writeHostIsolationExceptions']
    }, {
      id: 'host_isolation_exceptions_read',
      api: [`${_constants.APP_ID}-accessHostIsolationExceptions`],
      ui: ['accessHostIsolationExceptions']
    }]
  },
  [_product_features_keys.ProductFeatureSecurityKey.endpointResponseActions]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.responseActionsHistory, _product_features_keys.SecuritySubFeatureId.hostIsolation, _product_features_keys.SecuritySubFeatureId.processOperations, _product_features_keys.SecuritySubFeatureId.fileOperations, _product_features_keys.SecuritySubFeatureId.executeAction, _product_features_keys.SecuritySubFeatureId.scanAction],
    subFeaturesPrivileges: [{
      id: 'host_isolation_all',
      api: [`${_constants.APP_ID}-writeHostIsolation`],
      ui: ['writeHostIsolation']
    }]
  },
  [_product_features_keys.ProductFeatureSecurityKey.securityWorkflowInsights]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.workflowInsights]
  },
  [_product_features_keys.ProductFeatureSecurityKey.endpointArtifactManagement]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.hostIsolationExceptionsBasic, _product_features_keys.SecuritySubFeatureId.trustedApplications, _product_features_keys.SecuritySubFeatureId.blocklist, _product_features_keys.SecuritySubFeatureId.eventFilters, _product_features_keys.SecuritySubFeatureId.globalArtifactManagement]
  },
  [_product_features_keys.ProductFeatureSecurityKey.endpointExceptions]: {
    subFeatureIds: [_product_features_keys.SecuritySubFeatureId.endpointExceptions]
  }
};