"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggedOutPage = LoggedOutPage;
exports.renderLoggedOutPage = renderLoggedOutPage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18nReact = require("@kbn/i18n-react");
var _std = require("@kbn/std");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/authentication/logged_out/logged_out_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LoggedOutPage({
  basePath,
  customBranding
}) {
  const customBrandingValue = (0, _useObservable.default)(customBranding.customBranding$);
  return /*#__PURE__*/_react.default.createElement(_components.AuthenticationStatePage, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.loggedOut.title",
      defaultMessage: "Successfully logged out",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }),
    logo: customBrandingValue === null || customBrandingValue === void 0 ? void 0 : customBrandingValue.logo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: (0, _std.parseNextURL)(window.location.href, basePath.serverBasePath),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.loggedOut.login",
    defaultMessage: "Log in",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  })));
}
function renderLoggedOutPage(services, {
  element
}, props) {
  _reactDom.default.render(services.rendering.addContext(/*#__PURE__*/_react.default.createElement(LoggedOutPage, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 49
    }
  }))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
}