"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSampleDataStatus = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_INTERVAL = 5000;
const useSampleDataStatus = () => {
  const {
    sampleDataIngest,
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const prevStatus = (0, _react.useRef)();
  const {
    data,
    isLoading,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: [_constants.QueryKeys.FetchSampleDataStatus],
    queryFn: () => sampleDataIngest.getStatus(),
    enabled: Boolean(sampleDataIngest === null || sampleDataIngest === void 0 ? void 0 : sampleDataIngest.getStatus),
    refetchInterval: responseData => (responseData === null || responseData === void 0 ? void 0 : responseData.status) === 'installing' ? REFRESH_INTERVAL : false,
    refetchOnMount: 'always'
  });
  (0, _react.useEffect)(() => {
    if (prevStatus.current === 'installing' && (data === null || data === void 0 ? void 0 : data.status) === 'installed') {
      toasts.addSuccess(_i18n.i18n.translate('xpack.searchIndices.sampleData.successNotification', {
        defaultMessage: 'The Sample Data was successfully installed'
      }));
    }
    if (prevStatus.current === 'installing' && (data === null || data === void 0 ? void 0 : data.status) === 'error') {
      toasts === null || toasts === void 0 ? void 0 : toasts.addError(new Error('Failed to install the Sample Data.'), {
        title: _i18n.i18n.translate('xpack.searchIndices.sampleData.errorNotification', {
          defaultMessage: 'Something went wrong while installing the Sample Data'
        })
      });
    }
    prevStatus.current = data === null || data === void 0 ? void 0 : data.status;
  }, [data === null || data === void 0 ? void 0 : data.status, toasts]);
  return {
    isInstalled: (data === null || data === void 0 ? void 0 : data.status) === 'installed',
    isInstalling: (data === null || data === void 0 ? void 0 : data.status) === 'installing',
    indexName: data === null || data === void 0 ? void 0 : data.indexName,
    dashboardId: data === null || data === void 0 ? void 0 : data.dashboardId,
    isLoading,
    refetch
  };
};
exports.useSampleDataStatus = useSampleDataStatus;