"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatelessHeaderPromo = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _promo = require("./promo");
var _cta_link = require("./cta_link");
var _use_kibana = require("../../hooks/use_kibana");
var _cta_button = require("./cta_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/header/stateless_promo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatelessHeaderPromo = () => {
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const ctaButtonLabel = _i18n.i18n.translate('xpack.searchHomepage.statelessPromo12.content.ctaButton', {
    defaultMessage: 'Start Building'
  });
  return /*#__PURE__*/_react.default.createElement(_promo.HeaderPromo, {
    title: _i18n.i18n.translate('xpack.searchHomepage.header.statelessPromo12.title', {
      defaultMessage: 'Get started building AI Agents and chatting with your data'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.header.statelessPromo12.description', {
      defaultMessage: 'Start building AI agents. Try Agent Builder to chat with your data using powerful native tools, or create your own agents and tools with hybrid search and ES|QL.'
    }),
    actions: [/*#__PURE__*/_react.default.createElement(_cta_button.HeaderCTAButton, {
      key: "12-agent-builder-button",
      "data-telemetry-id": "12-agent-builder-button",
      handleOnClick: () => {
        application.navigateToApp('agent_builder');
      },
      ariaLabel: ctaButtonLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, ctaButtonLabel), /*#__PURE__*/_react.default.createElement(_cta_link.HeaderCTALink, {
      key: "12-agent-builder-blog"
      // "search-promo-homepage-" is prepended to the telemetry id in HeaderCTALink
      ,
      "data-telemetry-id": "12-agent-builder-blog",
      href: "https://www.elastic.co/search-labs/blog/ai-agentic-workflows-elastic-ai-agent-builder",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchHomepage.statelessPromo12.content.ctaLink', {
      defaultMessage: 'Check out the docs'
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
};
exports.StatelessHeaderPromo = StatelessHeaderPromo;