"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GettingStartedRedirectGate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _searchSharedUi = require("@kbn/search-shared-ui");
var _use_search_getting_started_feature_flag = require("../hooks/use_search_getting_started_feature_flag");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GettingStartedRedirectGate = ({
  coreStart,
  children
}) => {
  const isFeatureFlagEnabled = (0, _use_search_getting_started_feature_flag.useSearchGettingStartedFeatureFlag)();
  const [userRoles, setUserRoles] = (0, _react.useState)([]);
  const [hasCheckedRole, setHasCheckedRole] = (0, _react.useState)(false);
  const hasRedirected = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    // Get user role
    coreStart.userProfile.getCurrent().then(userProfile => {
      const roles = (userProfile === null || userProfile === void 0 ? void 0 : userProfile.user.roles) || [];
      setUserRoles([...roles]); // Spread to convert readonly array to mutable
      setHasCheckedRole(true);
    });
  }, [coreStart]);
  (0, _react.useEffect)(() => {
    // Only attempt redirect once we've checked the role
    if (!hasCheckedRole || hasRedirected.current) {
      return;
    }
    const visited = localStorage.getItem(_searchSharedUi.GETTING_STARTED_LOCALSTORAGE_KEY);
    const isViewerRole = userRoles.length === 1 && userRoles.includes('viewer');
    const shouldRedirect = isFeatureFlagEnabled && !isViewerRole && (!visited || visited === 'false');
    if (shouldRedirect) {
      hasRedirected.current = true;
      coreStart.application.navigateToApp('searchGettingStarted');
    }
  }, [coreStart, isFeatureFlagEnabled, userRoles, hasCheckedRole]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
};
exports.GettingStartedRedirectGate = GettingStartedRedirectGate;