"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecorativeHorizontalStepper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/decorative_horizontal_stepper/decorative_horizontal_stepper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DecorativeHorizontalStepper = ({
  stepCount = 2
}) => {
  // Generate the steps dynamically based on the stepCount prop
  const horizontalSteps = Array.from({
    length: stepCount
  }, (_, index) => ({
    title: '',
    status: 'incomplete',
    onClick: () => {}
  }));
  return (
    /*#__PURE__*/
    /* This is a presentational component, not intended for user interaction:
    pointer-events: none, prevents user interaction with the component.
    inert prevents click, focus, and other interactive events, removing it from the tab order.
    role="presentation" indicates that this component is purely decorative and not interactive for assistive technologies.
    Together, these attributes help ensure the component is accesible. */
    _react.default.createElement(_eui.EuiStepsHorizontal, {
      css: (0, _react2.css)`
        pointer-events: none;
      `,
      steps: horizontalSteps,
      size: "s",
      role: "presentation"
      // @ts-ignore due to React 18 and TypeScript doesn't have native HTML inert attribute support yet
      ,
      inert: "",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 5
      }
    })
  );
};
exports.DecorativeHorizontalStepper = DecorativeHorizontalStepper;