"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CopyToSpaceSavedObjectsManagementAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _types = require("../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/services/actions/copy_saved_objects_to_space_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Wrapper = ({
  spacesApiUi,
  props
}) => {
  const LazyComponent = (0, _react.useMemo)(() => spacesApiUi.components.getCopyToSpaceFlyout, [spacesApiUi]);
  return /*#__PURE__*/_react.default.createElement(LazyComponent, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 10
    }
  }));
};
class CopyToSpaceSavedObjectsManagementAction extends _types.SavedObjectsManagementAction {
  constructor(spacesApiUi) {
    super();
    (0, _defineProperty2.default)(this, "id", 'copy_saved_objects_to_space');
    (0, _defineProperty2.default)(this, "euiAction", {
      name: _i18n.i18n.translate('savedObjectsManagement.copyToSpace.actionTitle', {
        defaultMessage: 'Copy to spaces'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.copyToSpace.actionDescription', {
        defaultMessage: 'Make a copy of this saved object in one or more spaces'
      }),
      icon: 'copy',
      type: 'icon',
      available: object => {
        return object.meta.namespaceType !== 'agnostic' && !object.meta.hiddenType;
      },
      onClick: object => {
        this.start(object);
      }
    });
    (0, _defineProperty2.default)(this, "render", () => {
      var _this$record$namespac;
      if (!this.record) {
        throw new Error('No record available! `render()` was likely called before `start()`.');
      }
      const props = {
        onClose: this.onClose,
        savedObjectTarget: {
          type: this.record.type,
          id: this.record.id,
          namespaces: (_this$record$namespac = this.record.namespaces) !== null && _this$record$namespac !== void 0 ? _this$record$namespac : [],
          title: this.record.meta.title,
          icon: this.record.meta.icon
        }
      };
      return /*#__PURE__*/_react.default.createElement(Wrapper, {
        spacesApiUi: this.spacesApiUi,
        props: props,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 12
        }
      });
    });
    (0, _defineProperty2.default)(this, "onClose", () => {
      this.finish();
    });
    this.spacesApiUi = spacesApiUi;
  }
}
exports.CopyToSpaceSavedObjectsManagementAction = CopyToSpaceSavedObjectsManagementAction;