"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showApiError = showApiError;
exports.showApiWarning = showApiWarning;
var _notification = require("./notification");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createToastConfig(error, errorTitle) {
  // Expect an error in the shape provided by http service.
  if (error && error.body) {
    const {
      error: errorString,
      statusCode,
      message
    } = error.body;
    return {
      title: errorTitle,
      text: `${statusCode}: ${errorString}. ${message}`
    };
  }
}
function showApiWarning(error, errorTitle) {
  const toastConfig = createToastConfig(error, errorTitle);
  if (toastConfig) {
    return _notification.toasts.addWarning(toastConfig);
  }

  // This error isn't an HTTP error, so let the fatal error screen tell the user something
  // unexpected happened.
  return _notification.fatalError.add(error, errorTitle);
}
function showApiError(error, errorTitle) {
  const toastConfig = createToastConfig(error, errorTitle);
  if (toastConfig) {
    return _notification.toasts.addDanger(toastConfig);
  }

  // This error isn't an HTTP error, so let the fatal error screen tell the user something
  // unexpected happened.
  _notification.fatalError.add(error, errorTitle);
}