"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackTraces = StackTraces;
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireWildcard(require("react"));
var _topn = require("../../../common/topn");
var _use_profiling_dependencies = require("../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _stack_traces = require("../../components/stack_traces");
var _use_async = require("../../hooks/use_async");
var _empty_data_prompt = require("../empty_data_prompt");
var _error_prompt = require("../error_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/embeddables/stack_traces/stack_traces.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StackTraces({
  type,
  kuery,
  rangeFrom,
  rangeTo,
  onClick,
  onChartBrushEnd
}) {
  var _state$data;
  const {
    services: {
      fetchTopN
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const [displayOption, setDisplayOption] = (0, _react.useState)(_profilingUtils.StackTracesDisplayOption.StackTraces);
  const rangeFromSec = rangeFrom / 1000;
  const rangeToSec = rangeTo / 1000;
  const state = (0, _use_async.useAsync)(({
    http
  }) => {
    return fetchTopN({
      http,
      type,
      timeFrom: rangeFromSec,
      timeTo: rangeToSec,
      kuery
    }).then(_topn.groupSamplesByCategory);
  }, [fetchTopN, type, rangeFromSec, rangeToSec, kuery]);
  if (state.error) {
    return /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 12
      }
    });
  }
  if (state.status === _use_async.AsyncStatus.Settled && ((_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.charts.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_data_prompt.EmptyDataPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_stack_traces.StackTraces, {
    type: type,
    state: state,
    displayOption: displayOption,
    limit: 10,
    onChangeDisplayOption: setDisplayOption,
    onStackedBarChartBrushEnd: onChartBrushEnd,
    onChartClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
}