"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrimaryProfilingSearchBar = PrimaryProfilingSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _use_time_range_context = require("../../hooks/use_time_range_context");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _profiling_search_bar = require("./profiling_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/profiling_app_page_template/primary_profiling_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PrimaryProfilingSearchBar({
  showSubmitButton
}) {
  const {
    start: {
      data
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const {
    path,
    query
  } = (0, _use_profiling_params.useProfilingParams)('/*');
  if (!('rangeFrom' in query)) {
    throw new Error('Range query parameters are missing');
  }
  const {
    rangeFrom,
    rangeTo,
    kuery
  } = query;
  const {
    refresh
  } = (0, _use_time_range_context.useTimeRangeContext)();
  (0, _react.useEffect)(() => {
    // set time if both to and from are given in the url
    if (rangeFrom && rangeTo) {
      data.query.timefilter.timefilter.setTime({
        from: rangeFrom,
        to: rangeTo
      });
      return;
    }
  }, [rangeFrom, rangeTo, data]);
  return /*#__PURE__*/_react.default.createElement(_profiling_search_bar.ProfilingSearchBar, {
    kuery: kuery,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    onQuerySubmit: next => {
      var _next$query;
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          kuery: String(((_next$query = next.query) === null || _next$query === void 0 ? void 0 : _next$query.query) || ''),
          rangeFrom: next.dateRange.from,
          rangeTo: next.dateRange.to
        }
      });
    },
    onRefresh: nextDateRange => {
      profilingRouter.push(routePath, {
        path,
        query: {
          ...query,
          rangeFrom: nextDateRange.dateRange.from,
          rangeTo: nextDateRange.dateRange.to
        }
      });
    },
    onRefreshClick: () => {
      refresh();
    },
    showSubmitButton: showSubmitButton,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
}