"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PacksPage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _layouts = require("../../../components/layouts");
var _packs_table = require("../../../packs/packs_table");
var _add_pack_button = require("../../../packs/add_pack_button");
var _load_integration_assets = require("./load_integration_assets");
var _empty_state = require("./empty_state");
var _use_assets_status = require("../../../assets/use_assets_status");
var _use_packs = require("../../../packs/use_packs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/routes/packs/list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PacksPageComponent = () => {
  var _assetsData$install2;
  const {
    data: assetsData,
    isLoading: isLoadingAssetsStatus
  } = (0, _use_assets_status.useAssetsStatus)();
  const {
    data: packsData,
    isLoading: isLoadingPacks
  } = (0, _use_packs.usePacks)({});
  const showEmptyState = (0, _react.useMemo)(() => {
    var _assetsData$install;
    return !(packsData !== null && packsData !== void 0 && packsData.total) && (assetsData === null || assetsData === void 0 ? void 0 : (_assetsData$install = assetsData.install) === null || _assetsData$install === void 0 ? void 0 : _assetsData$install.length);
  }, [assetsData === null || assetsData === void 0 ? void 0 : (_assetsData$install2 = assetsData.install) === null || _assetsData$install2 === void 0 ? void 0 : _assetsData$install2.length, packsData === null || packsData === void 0 ? void 0 : packsData.total]);
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packList.pageTitle",
    defaultMessage: "Packs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.packList.pageSubtitle",
    defaultMessage: "Create packs to organize sets of queries and to schedule queries for agent policies.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 15
    }
  }))))), []);
  const RightColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_load_integration_assets.LoadIntegrationAssetsButton, {
    fill: !!showEmptyState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_add_pack_button.AddPackButton, {
    fill: !showEmptyState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }))), [showEmptyState]);
  const Content = (0, _react.useMemo)(() => {
    if (isLoadingAssetsStatus || isLoadingPacks) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 10,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 14
        }
      });
    }
    if (showEmptyState) {
      return /*#__PURE__*/_react.default.createElement(_empty_state.PacksTableEmptyState, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 14
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_packs_table.PacksTable, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 12
      }
    });
  }, [isLoadingAssetsStatus, isLoadingPacks, showEmptyState]);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumn: RightColumn,
    rightColumnGrow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, Content);
};
const PacksPage = exports.PacksPage = /*#__PURE__*/_react.default.memo(PacksPageComponent);