"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createResultStore = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createResultStore = conversation => {
  return new ToolResultStoreImpl(conversation ? (0, _utils.extractConversationToolResults)(conversation) : []);
};
exports.createResultStore = createResultStore;
class ToolResultStoreImpl {
  constructor(results) {
    (0, _defineProperty2.default)(this, "results", new Map());
    if (results) {
      this.results = new Map(results.map(result => [result.tool_result_id, result]));
    }
  }
  asReadonly() {
    return {
      has: resultId => this.has(resultId),
      get: resultId => this.get(resultId)
    };
  }
  add(result) {
    this.results.set(result.tool_result_id, result);
  }
  delete(resultId) {
    return this.results.delete(resultId);
  }
  has(resultId) {
    return this.results.has(resultId);
  }
  get(resultId) {
    if (!this.results.has(resultId)) {
      throw new Error(`Result with id ${resultId} does not exist`);
    }
    return this.results.get(resultId);
  }
}