"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareConversation = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _tools = require("@kbn/onechat-server/tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const prepareConversation = async ({
  previousRounds,
  nextInput,
  attachmentsService
}) => {
  const processedNextInput = await prepareRoundInput({
    input: nextInput,
    attachmentsService
  });
  const processedRounds = await Promise.all(previousRounds.map(round => {
    return prepareRound({
      round,
      attachmentsService
    });
  }));
  const attachmentTypeIds = [...new Set([...processedNextInput.attachments.map(attachment => attachment.attachment.type), ...processedRounds.flatMap(round => round.input.attachments.map(attachment => attachment.attachment.type))])];
  const attachmentTypes = await Promise.all(attachmentTypeIds.map(async type => {
    var _definition$getAgentD, _definition$getAgentD2;
    const definition = attachmentsService.getTypeDefinition(type);
    const description = (_definition$getAgentD = definition === null || definition === void 0 ? void 0 : (_definition$getAgentD2 = definition.getAgentDescription) === null || _definition$getAgentD2 === void 0 ? void 0 : _definition$getAgentD2.call(definition)) !== null && _definition$getAgentD !== void 0 ? _definition$getAgentD : '';
    return {
      type,
      description
    };
  }));
  return {
    nextInput: processedNextInput,
    previousRounds: processedRounds,
    attachmentTypes
  };
};
exports.prepareConversation = prepareConversation;
const prepareRound = async ({
  round,
  attachmentsService
}) => {
  return {
    ...round,
    input: await prepareRoundInput({
      input: round.input,
      attachmentsService
    })
  };
};
const prepareRoundInput = async ({
  input,
  attachmentsService
}) => {
  var _input$attachments;
  let attachments = [];
  if ((_input$attachments = input.attachments) !== null && _input$attachments !== void 0 && _input$attachments.length) {
    attachments = await Promise.all(input.attachments.map(attachment => {
      return prepareAttachment({
        attachment,
        attachmentsService
      });
    }));
  }
  return {
    message: input.message,
    attachments
  };
};
const prepareAttachment = async ({
  attachment: input,
  attachmentsService
}) => {
  const definition = attachmentsService.getTypeDefinition(input.type);
  if (!definition) {
    throw (0, _onechatCommon.createInternalError)(`Found attachment with unknown type: "${input.type}"`);
  }
  const attachment = inputToFinal(input);
  const formatted = await definition.format(attachment);
  return {
    attachment,
    representation: await formatted.getRepresentation()
  };
};
const inputToFinal = input => {
  var _input$id;
  return {
    ...input,
    id: (_input$id = input.id) !== null && _input$id !== void 0 ? _input$id : (0, _tools.getToolResultId)()
  };
};