"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalConversationRoutes = registerInternalConversationRoutes;
var _configSchema = require("@kbn/config-schema");
var _wrap_handler = require("../wrap_handler");
var _features = require("../../../common/features");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerInternalConversationRoutes({
  router,
  getInternalServices,
  logger
}) {
  const wrapHandler = (0, _wrap_handler.getHandlerWrapper)({
    logger
  });

  // rename conversation
  router.post({
    path: `${_constants.internalApiPath}/conversations/{conversation_id}/_rename`,
    validate: {
      params: _configSchema.schema.object({
        conversation_id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        title: _configSchema.schema.string()
      })
    },
    options: {
      access: 'internal'
    },
    security: {
      authz: {
        requiredPrivileges: [_features.apiPrivileges.readOnechat]
      }
    }
  }, wrapHandler(async (ctx, request, response) => {
    const {
      conversations: conversationsService
    } = getInternalServices();
    const {
      conversation_id: conversationId
    } = request.params;
    const {
      title
    } = request.body;
    const client = await conversationsService.getScopedClient({
      request
    });
    const updatedConversation = await client.update({
      id: conversationId,
      title
    });
    return response.ok({
      body: {
        id: updatedConversation.id,
        title: updatedConversation.title
      }
    });
  }));
}