"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _doc_links = require("../common/doc_links");
var _features = require("../common/features");
var _register_locators = require("./locator/register_locators");
var _register = require("./register");
var _lazy_onechat_nav_control = require("./components/nav_control/lazy_onechat_nav_control");
var _services = require("./services");
var _tools = require("./services/tools");
var _open_conversation_flyout = require("./flyout/open_conversation_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class OnechatPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "conversationFlyoutActiveConfig", {});
    (0, _defineProperty2.default)(this, "internalServices", void 0);
    (0, _defineProperty2.default)(this, "setupServices", void 0);
    this.logger = context.logger.get();
  }
  setup(core, deps) {
    var _deps$licenseManageme;
    const isAgentBuilderEnabled = core.settings.client.get(_managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID, true);
    const navigationService = new _services.NavigationService({
      management: deps.management.locator,
      licenseManagement: (_deps$licenseManageme = deps.licenseManagement) === null || _deps$licenseManageme === void 0 ? void 0 : _deps$licenseManageme.locator
    });
    this.setupServices = {
      navigationService
    };
    if (isAgentBuilderEnabled) {
      (0, _register.registerApp)({
        core,
        getServices: () => {
          if (!this.internalServices) {
            throw new Error('getServices called before plugin start');
          }
          return this.internalServices;
        }
      });
      (0, _register.registerAnalytics)({
        analytics: core.analytics
      });
      (0, _register_locators.registerLocators)(deps.share);
    }
    try {
      core.getStartServices().then(([coreStart]) => {
        const {
          capabilities
        } = coreStart.application;
        if (capabilities[_features.ONECHAT_FEATURE_ID][_features.uiPrivileges.showManagement]) {
          (0, _register.registerManagementSection)({
            core,
            management: deps.management
          });
        }
      });
    } catch (error) {
      this.logger.error('Error registering Agent Builder management section', error);
    }
    return {};
  }
  start(core, startDependencies) {
    const {
      http
    } = core;
    const {
      licensing,
      inference
    } = startDependencies;
    _doc_links.docLinks.setDocLinks(core.docLinks.links);
    const agentService = new _services.AgentService({
      http
    });
    const chatService = new _services.ChatService({
      http
    });
    const conversationsService = new _services.ConversationsService({
      http
    });
    const toolsService = new _services.ToolsService({
      http
    });
    const accessChecker = new _services.AgentBuilderAccessChecker({
      licensing,
      inference
    });
    if (!this.setupServices) {
      throw new Error('plugin start called before plugin setup');
    }
    const {
      navigationService
    } = this.setupServices;
    const internalServices = {
      agentService,
      chatService,
      conversationsService,
      navigationService,
      toolsService,
      startDependencies,
      accessChecker
    };
    this.internalServices = internalServices;
    const isAgentBuilderEnabled = core.settings.client.get(_managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID, true);
    const isAgentBuilderNavEnabled = core.settings.client.get(_managementSettingsIds.AGENT_BUILDER_NAV_ENABLED_SETTING_ID, false);
    const onechatService = {
      tools: (0, _tools.createPublicToolContract)({
        toolsService
      }),
      setConversationFlyoutActiveConfig: config => {
        this.conversationFlyoutActiveConfig = config;
      },
      clearConversationFlyoutActiveConfig: () => {
        this.conversationFlyoutActiveConfig = {};
      },
      openConversationFlyout: options => {
        const config = options !== null && options !== void 0 ? options : this.conversationFlyoutActiveConfig;
        return (0, _open_conversation_flyout.openConversationFlyout)(config, {
          coreStart: core,
          services: internalServices
        });
      }
    };
    if (isAgentBuilderEnabled && isAgentBuilderNavEnabled) {
      core.chrome.navControls.registerRight({
        mount: element => {
          _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_lazy_onechat_nav_control.OnechatNavControlInitiator, {
            coreStart: core,
            pluginsStart: startDependencies,
            onechatService: onechatService,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 170,
              columnNumber: 13
            }
          }), element, () => {});
          return () => {
            _reactDom.default.unmountComponentAtNode(element);
          };
        },
        // right before the user profile
        order: 1001
      });
    }
    return onechatService;
  }
}
exports.OnechatPlugin = OnechatPlugin;