"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendPredefinedInitialMessage = void 0;
var _react = require("react");
var _conversation_context = require("../context/conversation/conversation_context");
var _use_conversation_id = require("../context/conversation/use_conversation_id");
var _send_message_context = require("../context/send_message/send_message_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSendPredefinedInitialMessage = () => {
  const context = (0, _conversation_context.useConversationContext)();
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const {
    sendMessage
  } = (0, _send_message_context.useSendMessage)();
  const hasSentInitialMessage = (0, _react.useRef)(false);
  const initialMessage = context.initialMessage;
  const isNewConversation = !conversationId;
  (0, _react.useEffect)(() => {
    if (initialMessage && isNewConversation && !hasSentInitialMessage.current) {
      hasSentInitialMessage.current = true;
      sendMessage({
        message: initialMessage
      });
    }
  }, [initialMessage, isNewConversation, sendMessage]);
  return {
    hasSentInitialMessage: hasSentInitialMessage.current
  };
};
exports.useSendPredefinedInitialMessage = useSendPredefinedInitialMessage;