"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoutedConversationsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _reactQuery = require("@kbn/react-query");
var _conversation_context = require("./conversation_context");
var _new_conversation = require("../../utils/new_conversation");
var _app_paths = require("../../utils/app_paths");
var _use_navigation = require("../../hooks/use_navigation");
var _use_onechat_service = require("../../hooks/use_onechat_service");
var _use_agents = require("../../hooks/agents/use_agents");
var _search_param_names = require("../../search_param_names");
var _use_conversation_actions = require("./use_conversation_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/context/conversation/routed_conversations_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RoutedConversationsProvider = ({
  children
}) => {
  var _location$state$shoul, _location$state, _location$state2;
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    conversationsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    conversationId: conversationIdParam
  } = (0, _reactRouterDom.useParams)();
  const conversationId = (0, _react.useMemo)(() => {
    return conversationIdParam === _new_conversation.newConversationId ? undefined : conversationIdParam;
  }, [conversationIdParam]);
  const location = (0, _reactRouterDom.useLocation)();
  const shouldStickToBottom = (_location$state$shoul = (_location$state = location.state) === null || _location$state === void 0 ? void 0 : _location$state.shouldStickToBottom) !== null && _location$state$shoul !== void 0 ? _location$state$shoul : true;
  const initialMessage = (_location$state2 = location.state) === null || _location$state2 === void 0 ? void 0 : _location$state2.initialMessage;

  // Get search params for agent ID syncing
  const [searchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const {
    agents
  } = (0, _use_agents.useOnechatAgents)();
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const shouldAllowConversationRedirectRef = (0, _react.useRef)(true);
  const agentIdSyncedRef = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    return () => {
      // On unmount disable conversation redirect
      shouldAllowConversationRedirectRef.current = false;
    };
  }, []);
  const navigateToConversation = (0, _react.useCallback)(({
    nextConversationId
  }) => {
    // Navigate to the conversation if redirect is allowed
    if (shouldAllowConversationRedirectRef.current) {
      const path = _app_paths.appPaths.chat.conversation({
        conversationId: nextConversationId
      });
      const params = undefined;
      const state = {
        shouldStickToBottom: false
      };
      navigateToOnechatUrl(path, params, state);
    }
  }, [shouldAllowConversationRedirectRef, navigateToOnechatUrl]);
  const onConversationCreated = (0, _react.useCallback)(({
    conversationId: id
  }) => {
    navigateToConversation({
      nextConversationId: id
    });
  }, [navigateToConversation]);
  const onDeleteConversation = (0, _react.useCallback)(({
    isCurrentConversation
  }) => {
    if (isCurrentConversation) {
      // If deleting current conversation, navigate to new conversation
      const path = _app_paths.appPaths.chat.new;
      navigateToOnechatUrl(path, undefined, {
        shouldStickToBottom: true
      });
    }
  }, [navigateToOnechatUrl]);
  const conversationActions = (0, _use_conversation_actions.useConversationActions)({
    conversationId,
    queryClient,
    conversationsService,
    onConversationCreated,
    onDeleteConversation
  });

  // Handle agent ID syncing from URL params (moved from useSyncAgentId)
  (0, _react.useEffect)(() => {
    if (agentIdSyncedRef.current || conversationId) {
      return;
    }

    // If we don't have a selected agent id, check for a valid agent id in the search params
    // This is used for the "chat with agent" action on the Agent pages
    const agentIdParam = searchParams.get(_search_param_names.searchParamNames.agentId);
    if (agentIdParam && agents.some(agent => agent.id === agentIdParam)) {
      // Agent id passed to sync is valid, set it and mark as synced
      conversationActions.setAgentId(agentIdParam);
      agentIdSyncedRef.current = true;
    }
  }, [searchParams, agents, conversationId, conversationActions]);
  const contextValue = (0, _react.useMemo)(() => ({
    conversationId,
    shouldStickToBottom,
    isEmbeddedContext: false,
    conversationActions,
    initialMessage
  }), [conversationId, shouldStickToBottom, conversationActions, initialMessage]);
  return /*#__PURE__*/_react.default.createElement(_conversation_context.ConversationContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, children);
};
exports.RoutedConversationsProvider = RoutedConversationsProvider;