"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexSearchToolRegistryEntry = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _tools = require("@kbn/onechat-common/tools");
var _index_search_configuration_fields = require("../../sections/configuration_fields/index_search_configuration_fields");
var _transform_index_search_form_data = require("../../../../../utils/transform_index_search_form_data");
var _index_search_tool_form_validation = require("../../validation/index_search_tool_form_validation");
var _zod_resolver = require("../../../../../utils/zod_resolver");
var _i18n = require("../../i18n");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexSearchToolRegistryEntry = exports.indexSearchToolRegistryEntry = {
  label: _i18n.i18nMessages.configuration.form.type.indexSearchOption,
  getConfigurationComponent: () => _index_search_configuration_fields.IndexSearchConfiguration,
  defaultValues: {
    ..._common.commonToolFormDefaultValues,
    type: _onechatCommon.ToolType.index_search,
    pattern: '',
    rowLimit: undefined,
    customInstructions: ''
  },
  toolToFormData: tool => {
    if (!(0, _tools.isIndexSearchTool)(tool)) {
      throw new Error('Expected index search tool');
    }
    return (0, _transform_index_search_form_data.transformIndexSearchToolToFormData)(tool);
  },
  formDataToCreatePayload: _transform_index_search_form_data.transformIndexSearchFormDataForCreate,
  formDataToUpdatePayload: _transform_index_search_form_data.transformIndexSearchFormDataForUpdate,
  getValidationResolver: services => {
    if (!(services !== null && services !== void 0 && services.toolsService)) {
      throw new Error('toolsService is required for index search validation');
    }
    return (0, _zod_resolver.zodResolver)((0, _index_search_tool_form_validation.createIndexSearchFormValidationSchema)(services.toolsService));
  }
};