"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatConversationsView = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = _interopRequireDefault(require("react"));
var _conversation = require("./conversation");
var _conversation_header = require("./conversation_header/conversation_header");
var _routed_conversations_provider = require("../../context/conversation/routed_conversations_provider");
var _send_message_context = require("../../context/send_message/send_message_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversations_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OnechatConversationsView = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const mainStyles = (0, _react.css)`
    border: none;
  `;
  const backgroundStyles = (0, _react.css)`
    background-color: ${euiTheme.colors.backgroundBasePlain};
  `;
  const headerHeight = `calc(${euiTheme.size.xl} * 2)`;
  const headerStyles = (0, _react.css)`
    ${backgroundStyles}
    justify-content: center;
    height: ${headerHeight};
  `;
  const contentStyles = (0, _react.css)`
    ${backgroundStyles}
    width: 100%;
    height: 100%;
    max-block-size: calc(var(--kbn-application--content-height) - ${headerHeight});
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 0 ${euiTheme.size.base} ${euiTheme.size.base} ${euiTheme.size.base};
  `;
  const labels = {
    header: _i18n.i18n.translate('xpack.onechat.conversationsView.header', {
      defaultMessage: 'Conversation header'
    }),
    content: _i18n.i18n.translate('xpack.onechat.conversationsView.content', {
      defaultMessage: 'Conversation content'
    })
  };
  return /*#__PURE__*/_react2.default.createElement(_routed_conversations_provider.RoutedConversationsProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_send_message_context.SendMessageProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "onechatPageConversations",
    grow: false,
    panelled: false,
    mainProps: {
      css: mainStyles
    },
    responsive: [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    css: headerStyles,
    bottomBorder: false,
    "aria-label": labels.header,
    paddingSize: "m",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation_header.ConversationHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "none",
    grow: true,
    contentProps: {
      css: contentStyles
    },
    "aria-label": labels.content,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_conversation.Conversation, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })))));
};
exports.OnechatConversationsView = OnechatConversationsView;