"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingEmptyState = ProfilingEmptyState;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _profiling = _interopRequireDefault(require("../../images/profiling.png"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/profiling/profiling_empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ProfilingEmptyState() {
  var _services$http, _services$docLinks, _services$docLinks2;
  const {
    services
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: _profiling.default,
      alt: "",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.observabilityShared.profilingEmptyState.title', {
      defaultMessage: 'Improve computational efficiency. Debug performance regressions. Reduce cloud spend.'
    })),
    layout: "horizontal",
    color: "plain",
    hasBorder: true,
    hasShadow: false,
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.observabilityShared.profilingEmptyState.body', {
      defaultMessage: 'Elastic Universal Profiling is a whole-system, always-on, continuous profiling solution that eliminates the need for code instrumentation, recompilation, on-host debug symbols, or service restarts. Leveraging eBPF, Universal Profiling operates within the Linux kernel space, capturing only the needed data with minimal overhead in an unobtrusive manner.'
    }))),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: (_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.basePath.prepend(`/app/profiling`),
      "data-test-subj": "infraProfilingEmptyStateAddProfilingButton",
      color: "primary",
      fill: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.observabilityShared.profilingEmptyState.addProfiling', {
      defaultMessage: 'Add profiling'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: `${(_services$docLinks = services.docLinks) === null || _services$docLinks === void 0 ? void 0 : _services$docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${(_services$docLinks2 = services.docLinks) === null || _services$docLinks2 === void 0 ? void 0 : _services$docLinks2.DOC_LINK_VERSION}/profiling-get-started.html`,
      "data-test-subj": "infraProfilingEmptyStateGoToDocsButton",
      target: "_blank",
      external: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.observabilityShared.profilingEmptyState.goToDocs', {
      defaultMessage: 'Go to docs'
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  });
}