"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProximalAlertsCallout = ProximalAlertsCallout;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_find_proximal_alerts = require("./hooks/use_find_proximal_alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/proximal_alerts_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ProximalAlertsCallout({
  alertDetail,
  switchTabs
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data,
    isError,
    isLoading
  } = (0, _use_find_proximal_alerts.useFindProximalAlerts)(alertDetail);
  const count = data === null || data === void 0 ? void 0 : data.total;
  if (isLoading || isError || count === undefined || count < 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.proximalAlert.description', {
    defaultMessage: '{count, plural, one {# alert was} other {# alerts were}} triggered around the same time.',
    values: {
      count
    }
  }), count > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-id": "see-proximal-alerts",
    "data-test-subj": "see-proximal-alerts",
    css: {
      marginLeft: euiTheme.size.s
    },
    onClick: () => switchTabs(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.proximalAlert.action', {
    defaultMessage: 'See related alerts'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'arrowRight',
    fontSize: 'xs',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  })));
}