"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAnnotations = ObservabilityAnnotations;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _moment = _interopRequireDefault(require("moment"));
var _obs_annotation = require("./obs_annotation");
var _new_line_annotation = require("./new_line_annotation");
var _new_rect_annotation = require("./new_rect_annotation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/annotations/components/observability_annotation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ObservabilityAnnotations({
  slo,
  tooltipSpecs,
  annotations,
  isCreateOpen,
  setIsCreateOpen
}) {
  const {
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const actions = [{
    label: _i18n.i18n.translate('xpack.observability.createAnnotation.addAnnotationModalHeaderTitleLabel', {
      defaultMessage: 'Create annotation'
    }),
    onSelect: (s, v) => {
      var _s$0$datum$key, _s$, _v$;
      setValue('@timestamp', (0, _moment.default)(new Date((_s$0$datum$key = s === null || s === void 0 ? void 0 : (_s$ = s[0]) === null || _s$ === void 0 ? void 0 : _s$.datum.key) !== null && _s$0$datum$key !== void 0 ? _s$0$datum$key : v === null || v === void 0 ? void 0 : (_v$ = v[0]) === null || _v$ === void 0 ? void 0 : _v$.datum.key)));
      setIsCreateOpen(true);
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, (0, _extends2.default)({}, tooltipSpecs !== null && tooltipSpecs !== void 0 ? tooltipSpecs : {}, {
    actions: actions,
    type: _charts.TooltipType.VerticalCursor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  })), annotations === null || annotations === void 0 ? void 0 : annotations.map((annotation, index) => {
    var _annotation$id;
    return /*#__PURE__*/_react.default.createElement(_obs_annotation.ObsAnnotation, {
      annotation: annotation,
      key: (_annotation$id = annotation.id) !== null && _annotation$id !== void 0 ? _annotation$id : index,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    });
  }), /*#__PURE__*/_react.default.createElement(_new_line_annotation.NewLineAnnotation, {
    slo: slo,
    isCreateOpen: isCreateOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_new_rect_annotation.NewRectAnnotation, {
    slo: slo,
    isCreateOpen: isCreateOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ObservabilityAnnotations;