"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupModeToggleButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _constants = require("../../../common/constants");
var _exit_button = require("./exit_button");
var _use_track_metric = require("../../application/hooks/use_track_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/setup_mode/toggle_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SetupModeToggleButton = props => {
  const [isLoading, setIsLoading] = _react.default.useState(false);
  const trackStat = (0, _use_track_metric.useUiTracker)();
  function toggleSetupMode(enabled, stat) {
    setIsLoading(true);
    props.toggleSetupMode(enabled);
    trackStat({
      metric: `${_constants.TELEMETRY_METRIC_BUTTON_CLICK}setupmode_${stat}`,
      metricType: _analytics.METRIC_TYPE.CLICK
    });
    setIsLoading(false);
  }
  if (props.enabled) {
    return /*#__PURE__*/_react.default.createElement(_exit_button.SetupModeExitButton, {
      exitSetupMode: () => toggleSetupMode(false, 'exit'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => toggleSetupMode(true, 'enter'),
    iconType: "flag",
    size: "s",
    iconSide: "right",
    isLoading: isLoading,
    "data-test-subj": "monitoringSetupModeBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.monitoring.setupMode.enter', {
    defaultMessage: 'Enter setup mode'
  }));
};
exports.SetupModeToggleButton = SetupModeToggleButton;