"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalySwimlanePropsSchema = exports.anomalySwimlaneInitialInputSchema = exports.anomalySwimlaneEmbeddableUserInputSchema = exports.anomalySwimlaneEmbeddableStateViewBySchema = exports.anomalySwimlaneEmbeddableCustomInputViewBySchema = exports.anomalySwimlaneEmbeddableCustomInputSchema = exports.anomalySwimlaneEmbeddableCustomInputOverallSchema = exports.anomalySwimLaneEmbeddableStateSchema = exports.anomalySwimLaneControlsStateSchema = exports.SWIMLANE_TYPE = void 0;
var _configSchema = require("@kbn/config-schema");
var _dataServiceServer = require("@kbn/data-service-server");
var _esQueryServer = require("@kbn/es-query-server");
var _presentationPublishingSchemas = require("@kbn/presentation-publishing-schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SWIMLANE_TYPE = exports.SWIMLANE_TYPE = {
  OVERALL: 'overall',
  VIEW_BY: 'viewBy'
};
const swimlaneTypeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(SWIMLANE_TYPE.OVERALL), _configSchema.schema.literal(SWIMLANE_TYPE.VIEW_BY)]);
const commonUserInputProps = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const anomalySwimlaneOverallSchema = _configSchema.schema.object({
  swimlaneType: _configSchema.schema.literal(SWIMLANE_TYPE.OVERALL),
  ...commonUserInputProps.getPropSchemas()
});
const anomalySwimlaneViewBySchema = _configSchema.schema.object({
  swimlaneType: _configSchema.schema.literal(SWIMLANE_TYPE.VIEW_BY),
  viewBy: _configSchema.schema.string(),
  ...commonUserInputProps.getPropSchemas()
});
const anomalySwimlaneEmbeddableCustomInputCommonSchema = _configSchema.schema.object({
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_esQueryServer.storedFilterSchema)),
  query: _configSchema.schema.maybe(_esQueryServer.querySchema),
  timeRange: _configSchema.schema.maybe(_esQueryServer.timeRangeSchema),
  refreshConfig: _configSchema.schema.maybe(_dataServiceServer.refreshIntervalSchema)
});
const anomalySwimlaneEmbeddableCustomInputViewBySchema = exports.anomalySwimlaneEmbeddableCustomInputViewBySchema = _configSchema.schema.object({
  ...anomalySwimlaneViewBySchema.getPropSchemas(),
  ...anomalySwimlaneEmbeddableCustomInputCommonSchema.getPropSchemas()
});
const anomalySwimlaneEmbeddableCustomInputOverallSchema = exports.anomalySwimlaneEmbeddableCustomInputOverallSchema = _configSchema.schema.object({
  ...anomalySwimlaneOverallSchema.getPropSchemas(),
  ...anomalySwimlaneEmbeddableCustomInputCommonSchema.getPropSchemas()
});
const anomalySwimlaneEmbeddableCustomInputSchema = exports.anomalySwimlaneEmbeddableCustomInputSchema = _configSchema.schema.oneOf([anomalySwimlaneEmbeddableCustomInputViewBySchema, anomalySwimlaneEmbeddableCustomInputOverallSchema]);
const anomalySwimlaneEmbeddableUserInputSchema = exports.anomalySwimlaneEmbeddableUserInputSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  swimlaneType: swimlaneTypeSchema,
  viewBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  panelTitle: _configSchema.schema.maybe(_configSchema.schema.string())
});
const anomalySwimlanePropsSchema = exports.anomalySwimlanePropsSchema = _configSchema.schema.object({
  ...anomalySwimlaneEmbeddableCustomInputCommonSchema.getPropSchemas(),
  ...anomalySwimlaneEmbeddableUserInputSchema.getPropSchemas()
});
const anomalySwimlaneInitialInputSchema = exports.anomalySwimlaneInitialInputSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  swimlaneType: _configSchema.schema.maybe(swimlaneTypeSchema),
  viewBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  title: _configSchema.schema.maybe(_configSchema.schema.string()),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number())
});
const anomalySwimLaneControlsStateSchema = exports.anomalySwimLaneControlsStateSchema = _configSchema.schema.object({
  jobIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  swimlaneType: swimlaneTypeSchema,
  viewBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number())
});
const anomalySwimlaneEmbeddableStateViewBySchema = exports.anomalySwimlaneEmbeddableStateViewBySchema = _configSchema.schema.object({
  ..._presentationPublishingSchemas.serializedTitlesSchema.getPropSchemas(),
  ...anomalySwimlaneEmbeddableCustomInputViewBySchema.getPropSchemas()
});
const anomalySwimlaneEmbeddableStateOverallSchema = _configSchema.schema.object({
  ..._presentationPublishingSchemas.serializedTitlesSchema.getPropSchemas(),
  ...anomalySwimlaneEmbeddableCustomInputOverallSchema.getPropSchemas()
});
const anomalySwimLaneEmbeddableStateSchema = exports.anomalySwimLaneEmbeddableStateSchema = _configSchema.schema.oneOf([anomalySwimlaneEmbeddableStateViewBySchema, anomalySwimlaneEmbeddableStateOverallSchema]);