"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getZeroShotClassificationInput = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _text_input = require("../text_input");
var _inference_base = require("../inference_base");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/model_management/test_models/models/text_classification/zero_shot_classification_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ClassNameInput = ({
  inferrer
}) => {
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  const labelsText = (0, _useObservable.default)(inferrer.getLabelsText$(), inferrer.getLabelsText());
  const multiLabel = (0, _useObservable.default)(inferrer.getMultiLabel$(), inferrer.getMultiLabel());
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textClassification.classNamesInput', {
      defaultMessage: 'Class labels'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textClassification.classNamesHelpText', {
      defaultMessage: 'Separate the labels with commas'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: labelsText,
    disabled: runningState === _inference_base.RUNNING_STATE.RUNNING,
    fullWidth: true,
    onChange: e => inferrer.setLabelsText(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textClassification.multiLabelHelpText', {
      defaultMessage: 'Enable the input text to match more than one label.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textClassification.multiLabelSwitch', {
      defaultMessage: 'Multi label'
    }),
    checked: multiLabel,
    onChange: e => inferrer.setMultiLabel(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  })));
};
const getZeroShotClassificationInput = (inferrer, placeholder) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inferrer.getInputType() === _inference_base.INPUT_TYPE.TEXT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_text_input.TextInput, {
  placeholder: placeholder,
  inferrer: inferrer,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 9
  }
})) : null, /*#__PURE__*/_react.default.createElement(ClassNameInput, {
  inferrer: inferrer,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 88,
    columnNumber: 5
  }
}));
exports.getZeroShotClassificationInput = getZeroShotClassificationInput;