"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsStepDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _page = require("../../page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/details_step/details_step_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DetailsStepDetails = ({
  setCurrentStep,
  state
}) => {
  const {
    form,
    isJobCreated
  } = state;
  const {
    description,
    jobId,
    destinationIndex,
    resultsField
  } = form;
  const detailsFirstCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.jobId', {
      defaultMessage: 'Job ID'
    }),
    description: jobId
  }];
  if (resultsField !== undefined && typeof resultsField === 'string' && resultsField.trim() !== '') {
    detailsFirstCol.push({
      title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.resultsField', {
        defaultMessage: 'Results field'
      }),
      description: resultsField
    });
  }
  const detailsSecondCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.jobDescription', {
      defaultMessage: 'Job description'
    }),
    description
  }];
  const detailsThirdCol = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.configDetails.destIndex', {
      defaultMessage: 'Destination index'
    }),
    description: destinationIndex || ''
  }];
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      width: '70%'
    },
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsFirstCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    style: {
      wordBreak: 'break-word'
    },
    compressed: true,
    listItems: detailsSecondCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detailsThirdCol,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }), !isJobCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "pencil",
    size: "s",
    onClick: () => {
      setCurrentStep(_page.ANALYTICS_STEPS.DETAILS);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.detailsDetails.editButtonText', {
    defaultMessage: 'Edit'
  })));
};
exports.DetailsStepDetails = DetailsStepDetails;