"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMessages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _component_utils = require("../../util/component_utils");
var _job_message_icon = require("../job_message_icon");
var _ml = require("../../contexts/ml");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_messages/job_messages.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component for rendering job messages for anomaly detection
 * and data frame analytics jobs.
 */
const JobMessages = ({
  messages,
  loading,
  error,
  refreshMessage,
  actionHandler
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      name: refreshMessage ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.ml.jobMessages.refreshLabel', {
          defaultMessage: 'Refresh'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: (0, _component_utils.blurButtonOnClick)(() => {
          refreshMessage();
        }),
        iconType: "refresh",
        "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.refreshAriaLabel', {
          defaultMessage: 'Refresh'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 13
        }
      })) : '',
      render: message => /*#__PURE__*/_react.default.createElement(_job_message_icon.JobIcon, {
        message: message,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 42
        }
      }),
      width: `${euiTheme.size.xl}`,
      align: 'center'
    }, {
      field: 'timestamp',
      name: _i18n.i18n.translate('xpack.ml.jobMessages.timeLabel', {
        defaultMessage: 'Time'
      }),
      render: _mlDateUtils.timeFormatter,
      width: '25%',
      sortable: true
    }, {
      field: 'message',
      name: _i18n.i18n.translate('xpack.ml.jobMessages.messageLabel', {
        defaultMessage: 'Message'
      })
    }];
    if (showNodeInfo) {
      cols.splice(2, 0, {
        field: 'node_name',
        name: _i18n.i18n.translate('xpack.ml.jobMessages.nodeLabel', {
          defaultMessage: 'Node'
        }),
        width: '15%'
      });
    }
    if (typeof actionHandler === 'function') {
      cols.push({
        name: _i18n.i18n.translate('xpack.ml.jobMessages.actionsLabel', {
          defaultMessage: 'Actions'
        }),
        width: '15%',
        actions: [{
          render: message => {
            return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
              content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.ml.jobMessages.toggleInChartTooltipText",
                defaultMessage: "Toggle in chart",
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 111,
                  columnNumber: 21
                }
              }),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 109,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
              size: "xs",
              "aria-label": _i18n.i18n.translate('xpack.ml.jobMessages.toggleInChartAriaLabel', {
                defaultMessage: 'Toggle in chart'
              }),
              iconType: "visAreaStacked",
              onClick: () => actionHandler(message),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 117,
                columnNumber: 19
              }
            }));
          }
        }]
      });
    }
    return cols;
  }, [refreshMessage, euiTheme.size.xl, showNodeInfo, actionHandler]);
  const defaultSorting = {
    sort: {
      field: 'timestamp',
      direction: 'desc'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: messages,
    columns: columns,
    sorting: defaultSorting,
    compressed: true,
    loading: loading,
    error: error,
    pagination: {
      initialPageSize: 25
    },
    "data-test-subj": 'mlAnalyticsDetailsJobMessagesTable',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }));
};
exports.JobMessages = JobMessages;