"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOP_LEVEL_ACTUAL_TYPICAL_FIELDS = exports.RECORD_INFLUENCER_FIELDS = exports.NESTED_ACTUAL_TYPICAL_FIELDS = exports.INFLUENCER_FILTER_FIELDS = exports.DISALLOWED_FILTER_FIELDS = exports.DETECTOR_FILTER_FIELDS = exports.BASE_RECORD_FILTER_FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Base record fields that are always available for filtering anomaly records,
 * regardless of job configuration.
 */
const BASE_RECORD_FILTER_FIELDS = exports.BASE_RECORD_FILTER_FIELDS = ['initial_record_score', 'function', 'field_name'];

/**
 * Influencer fields for anomaly records when jobs have influencers configured.
 */
const RECORD_INFLUENCER_FIELDS = exports.RECORD_INFLUENCER_FIELDS = ['influencers.influencer_field_name', 'influencers.influencer_field_values'];

/**
 * Influencer fields available for filtering anomaly influencers.
 */
const INFLUENCER_FILTER_FIELDS = exports.INFLUENCER_FILTER_FIELDS = ['influencer_field_name', 'influencer_field_value'];

/**
 * Detector field names used in anomaly records.
 */
const DETECTOR_FILTER_FIELDS = exports.DETECTOR_FILTER_FIELDS = {
  PARTITION_FIELD_NAME: 'partition_field_name',
  PARTITION_FIELD_VALUE: 'partition_field_value',
  BY_FIELD_NAME: 'by_field_name',
  BY_FIELD_VALUE: 'by_field_value',
  OVER_FIELD_NAME: 'over_field_name',
  OVER_FIELD_VALUE: 'over_field_value'
};

/**
 * Actual/typical value fields for non-population jobs.
 */
const TOP_LEVEL_ACTUAL_TYPICAL_FIELDS = exports.TOP_LEVEL_ACTUAL_TYPICAL_FIELDS = ['actual', 'typical'];

/**
 * Nested field for population jobs (actual/typical are nested under causes).
 */
const NESTED_ACTUAL_TYPICAL_FIELDS = exports.NESTED_ACTUAL_TYPICAL_FIELDS = ['causes.actual', 'causes.typical'];
const DISALLOWED_FILTER_FIELDS = exports.DISALLOWED_FILTER_FIELDS = ['job_id', 'is_interim', 'record_score', 'influencer_score'];