"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveFieldCaps = retrieveFieldCaps;
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../common/fields/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function retrieveFieldCaps({
  esClient,
  indexPattern,
  fields = '*',
  timerange: {
    from,
    to
  }
}) {
  const indexFieldCapsMap = new Map();

  // First, resolve the index pattern to get data streams or indices
  const resolveResponse = await esClient.indices.resolveIndex({
    name: indexPattern,
    expand_wildcards: 'open'
  });

  // Extract resolved indices (data streams and regular indices)
  const resolvedIndices = [...resolveResponse.data_streams, ...resolveResponse.indices];
  const uniqueFieldTypes = new Set([..._constants.NUMERIC_TYPES, ..._constants.DIMENSION_TYPES]);

  // Call field caps in parallel for each index
  const fieldCapsPromises = resolvedIndices.map(async index => {
    const fieldCaps = await esClient.fieldCaps({
      index: index.name,
      fields,
      include_unmapped: false,
      index_filter: (0, _esQuery.dateRangeQuery)(from, to)[0],
      types: [...uniqueFieldTypes]
    });
    if (Object.keys(fieldCaps.fields).length > 0) {
      indexFieldCapsMap.set(index.name, fieldCaps.fields);
    }
  });

  // Wait for all field caps requests to complete
  await Promise.all(fieldCapsPromises);

  // Return the index field caps map
  return indexFieldCapsMap;
}