"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsDataClient = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MetricsDataClient {
  constructor(http) {
    this.http = http;
  }
  async metricsExplorer(body) {
    return this.http.post('/api/infra/metrics_explorer', {
      body: JSON.stringify(body)
    });
  }
  async metricsIndices() {
    return this.http.get('/api/metrics/indices');
  }
}
exports.MetricsDataClient = MetricsDataClient;