"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterByMapExtentModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _map_embeddables_singleton = require("../../react_embeddable/map_embeddables_singleton");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/trigger_actions/filter_by_map_extent/modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FilterByMapExtentModal extends _react.Component {
  _renderSwitches() {
    return _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels().map(mapPanel => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressed",
        key: mapPanel.id,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: mapPanel.getTitle(),
        checked: mapPanel.getIsFilterByMapExtent(),
        onChange: event => {
          const isChecked = event.target.checked;
          mapPanel.setIsFilterByMapExtent(isChecked);

          // only a single map can create map bound filter at a time
          // disable all other map panels from creating map bound filter
          if (isChecked) {
            _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels().forEach(it => {
              if (it.id !== mapPanel.id && it.getIsFilterByMapExtent()) {
                it.setIsFilterByMapExtent(false);
              }
            });
          }
          this.forceUpdate();
        },
        compressed: true,
        "data-test-subj": `filterByMapExtentSwitch${mapPanel.id}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 11
        }
      }));
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, this.props.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, this._renderSwitches()));
  }
}
exports.FilterByMapExtentModal = FilterByMapExtentModal;