"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TermJoinKeyLabel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/tooltips/term_join_tooltip_property/term_join_key_label.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TermJoinKeyLabel extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      rightSourceLabels: []
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadRightSourceLabels();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadRightSourceLabels() {
    const rightSourceLabels = await (0, _std.asyncMap)(this.props.termJoins, async termJoin => {
      const termField = termJoin.getTermField();
      return `'${await termField.getLabel()}'`;
    });
    if (this._isMounted) {
      this.setState({
        rightSourceLabels
      });
    }
  }
  render() {
    if (this.state.rightSourceLabels.length === 0) {
      return this.props.leftFieldName;
    }
    const content = _i18n.i18n.translate('xpack.maps.tooltip.joinPropertyTooltipContent', {
      defaultMessage: `Shared key ''{leftFieldName}'' is joined with {rightSources}`,
      values: {
        leftFieldName: this.props.leftFieldName,
        rightSources: this.state.rightSourceLabels.join(',')
      }
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, this.props.leftFieldName, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: content,
      type: "link",
      position: "bottom",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }));
  }
}
exports.TermJoinKeyLabel = TermJoinKeyLabel;